/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.MergedObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DomModelImpl<T extends DomElement> {
    protected final DomFileElement<T> myMergedModel;
    protected final Set<XmlFile> myConfigFiles;
    private Class<T> myClass;
    private Project myProject;

    @Deprecated
    public DomModelImpl(T mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (configFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelImpl.<init> must not be null");
        }
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(DomFileElement<T> mergedModel, @NotNull Set<XmlFile> configFiles) {
        if (configFiles == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelImpl.<init> must not be null");
        }
        this.myMergedModel = DomUtil.getFileElement(mergedModel);
        this.myConfigFiles = configFiles;
    }

    public DomModelImpl(@NotNull Set<XmlFile> configFiles, Class<T> clazz, Project project) {
        if (configFiles == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelImpl.<init> must not be null");
        }
        this.myProject = project;
        this.myMergedModel = null;
        this.myConfigFiles = configFiles;
        this.myClass = clazz;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public T getMergedModel() {
        Object object;
        if (this.myMergedModel == null) {
            final DomManager domManager = DomManager.getDomManager(this.myProject);
            object = (DomElement)domManager.createModelMerger().mergeModels(this.myClass, ContainerUtil.mapNotNull(this.myConfigFiles, (Function)new NullableFunction<XmlFile, T>(){

                public T fun(XmlFile xmlFile) {
                    DomFileElement fileElement = domManager.getFileElement(xmlFile, DomModelImpl.this.myClass);
                    return fileElement == null ? null : (Object)fileElement.getRootElement();
                }
            }));
            if (object == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelImpl.getMergedModel must not return null");
            return object;
        }
        object = this.myMergedModel.getRootElement();
        if (object != null) return object;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelImpl.getMergedModel must not return null");
    }

    @NotNull
    public Set<XmlFile> getConfigFiles() {
        Set<XmlFile> set = this.myConfigFiles;
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelImpl.getConfigFiles must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<DomFileElement<T>> getRoots() {
        List<DomFileElement<Object>> list;
        if (this.myMergedModel == null) {
            list = ContainerUtil.mapNotNull(this.myConfigFiles, (Function)new NullableFunction<XmlFile, DomFileElement<T>>(){

                public DomFileElement<T> fun(XmlFile xmlFile) {
                    return DomManager.getDomManager(xmlFile.getProject()).getFileElement(xmlFile, DomModelImpl.this.myClass);
                }
            });
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelImpl.getRoots must not return null");
            return list;
        }
        list = this.myMergedModel instanceof MergedObject ? ((MergedObject)((Object)this.myMergedModel)).getImplementations() : Collections.singletonList(this.myMergedModel);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/model/impl/DomModelImpl.getRoots must not return null");
    }
}

