/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.ui.Table;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class EditSourceOnDoubleClickHandler {
    private EditSourceOnDoubleClickHandler() {
    }

    public static void install(JTree tree, @Nullable Runnable whenPerformed) {
        tree.addMouseListener(new TreeMouseListener(tree, whenPerformed));
    }

    public static void install(JTree tree) {
        EditSourceOnDoubleClickHandler.install(tree, null);
    }

    public static void install(final TreeTable treeTable) {
        treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return;
                }
                if (treeTable.getTree().getPathForLocation(e.getX(), e.getY()) == null) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)treeTable));
                Project project = PlatformDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
            }
        });
    }

    public static void install(final Table table) {
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (ModalityState.current().dominates(ModalityState.NON_MODAL)) {
                    return;
                }
                if (table.columnAtPoint(e.getPoint()) < 0) {
                    return;
                }
                if (table.rowAtPoint(e.getPoint()) < 0) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)table);
                Project project = PlatformDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return;
                }
                OpenSourceUtil.openSourcesFrom(dataContext, true);
            }
        });
    }

    public static void install(final JList list, final Runnable whenPerformed) {
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                Point point = e.getPoint();
                int index = list.locationToIndex(point);
                if (index == -1) {
                    return;
                }
                if (!list.getCellBounds(index, index).contains(point)) {
                    return;
                }
                DataContext dataContext = DataManager.getInstance().getDataContext(list);
                OpenSourceUtil.openSourcesFrom(dataContext, true);
                whenPerformed.run();
            }
        });
    }

    public static class TreeMouseListener
    extends MouseAdapter {
        private final JTree myTree;
        @Nullable
        private final Runnable myWhenPerformed;

        public TreeMouseListener(JTree tree) {
            this(tree, null);
        }

        public TreeMouseListener(JTree tree, @Nullable Runnable whenPerformed) {
            this.myTree = tree;
            this.myWhenPerformed = whenPerformed;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (1 != e.getButton() || e.getClickCount() != 2) {
                return;
            }
            if (this.myTree.getPathForLocation(e.getX(), e.getY()) == null) {
                return;
            }
            DataContext dataContext = DataManager.getInstance().getDataContext(this.myTree);
            Project project = PlatformDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            TreePath selectionPath = this.myTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (((TreeNode)lastPathComponent).isLeaf() || !TreeMouseListener.expandOnDoubleClick((TreeNode)lastPathComponent)) {
                this.processDoubleClick(e, dataContext, (TreeNode)lastPathComponent);
            }
        }

        protected void processDoubleClick(MouseEvent e, DataContext dataContext, TreeNode lastPathComponent) {
            OpenSourceUtil.openSourcesFrom(dataContext, true);
            if (this.myWhenPerformed != null) {
                this.myWhenPerformed.run();
            }
        }

        private static boolean expandOnDoubleClick(TreeNode treeNode) {
            Object userObject;
            if (treeNode instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)treeNode).getUserObject()) instanceof NodeDescriptor) {
                return ((NodeDescriptor)userObject).expandOnDoubleClick();
            }
            return true;
        }
    }
}

