/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ModuleGroupingRule
implements UsageGroupingRule {
    @Override
    public UsageGroup groupUsage(Usage usage) {
        UsageInLibrary usageInLibrary;
        OrderEntry entry;
        UsageInModule usageInModule;
        Module module;
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            return new ModuleUsageGroup(module);
        }
        if (usage instanceof UsageInLibrary && (entry = (usageInLibrary = (UsageInLibrary)usage).getLibraryEntry()) != null) {
            return new LibraryUsageGroup(entry);
        }
        return null;
    }

    private static class ModuleUsageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final Module myModule;

        public ModuleUsageGroup(Module module) {
            this.myModule = module;
        }

        @Override
        public void update() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return !(this.myModule != null ? !this.myModule.equals(moduleUsageGroup.myModule) : moduleUsageGroup.myModule != null);
        }

        public int hashCode() {
            return this.myModule != null ? this.myModule.hashCode() : 0;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.myModule.getModuleType().getNodeIcon(isOpen);
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myModule.isDisposed() ? "" : this.myModule.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup.getText must not return null");
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        @Override
        public void navigate(boolean focus) throws UnsupportedOperationException {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(UsageGroup o) {
            if (o instanceof LibraryUsageGroup) {
                return -1;
            }
            return this.getText(null).compareTo(o.getText(null));
        }

        public String toString() {
            return UsageViewBundle.message("node.group.module", new Object[0]) + this.getText(null);
        }

        @Override
        public void calcData(DataKey key, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (LangDataKeys.MODULE_CONTEXT == key) {
                sink.put(LangDataKeys.MODULE_CONTEXT, this.myModule);
            }
        }
    }

    private static class LibraryUsageGroup
    implements UsageGroup {
        public static final Icon LIBRARY_ICON = IconLoader.getIcon((String)"/nodes/ppLibOpen.png");
        OrderEntry myEntry;

        @Override
        public void update() {
        }

        public LibraryUsageGroup(OrderEntry entry) {
            this.myEntry = entry;
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return LIBRARY_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.myEntry.getPresentableName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup.getText must not return null");
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public int compareTo(UsageGroup usageGroup) {
            if (usageGroup instanceof ModuleUsageGroup) {
                return 1;
            }
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        @Override
        public void navigate(boolean requestFocus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LibraryUsageGroup)) {
                return false;
            }
            return this.myEntry.equals(((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }
    }
}

