/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.GroupedElementsRenderer;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SeparatorWithText
extends JComponent {
    private static final int VGAP = 3;
    private static final int HGAP = 3;
    private String myCaption = "";
    private int myPrefWidth;

    public SeparatorWithText() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        String labelFont = "Label.font";
        this.setFont(UIManager.getFont("Label.font"));
        this.setFont(this.getFont().deriveFont(1));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.getPreferredFontSize();
        size.width = this.myPrefWidth == -1 ? size.width : this.myPrefWidth;
        return size;
    }

    public Dimension getPreferredFontSize() {
        if (this.hasCaption()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int preferredHeight = fm.getHeight();
            int preferredWidth = this.getPreferredWidth(fm);
            return new Dimension(preferredWidth, preferredHeight + 6);
        }
        return new Dimension(0, 7);
    }

    private int getPreferredWidth(FontMetrics fm) {
        return fm.stringWidth(this.myCaption) + 6;
    }

    private boolean hasCaption() {
        return this.myCaption != null && !"".equals(this.myCaption.trim());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setMinimumWidth(int width) {
        this.myPrefWidth = width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(GroupedElementsRenderer.POPUP_SEPARATOR_FOREGROUND);
        if (this.hasCaption()) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int baseline = 3 + fm.getAscent();
            int fontWidth = this.getPreferredFontSize().width;
            int lineX = (this.getWidth() - fontWidth) / 2;
            int lineY = 3 + fm.getHeight() / 2;
            g.drawLine(0, lineY, lineX, lineY);
            g.drawString(this.myCaption, lineX + 3, baseline);
            g.drawLine(lineX + fontWidth, lineY, this.getWidth() - 1, lineY);
        } else {
            g.drawLine(0, 3, this.getWidth() - 1, 3);
        }
    }

    public void setCaption(String captionAboveOf) {
        this.myCaption = captionAboveOf;
    }
}

