/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class ColoredTreeCellRenderer
extends SimpleColoredComponent
implements TreeCellRenderer {
    private static final Icon LOADING_NODE_ICON = new EmptyIcon(8, 16);
    protected boolean mySelected;
    protected boolean myFocused;
    protected JTree myTree;
    private boolean myOpaque = true;

    @Override
    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myTree = tree;
        this.clear();
        this.mySelected = selected;
        this.myFocused = tree.hasFocus();
        if (UIUtil.isFullRowSelectionLAF()) {
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : null);
        } else if (selected) {
            this.setPaintFocusBorder(true);
            if (this.myFocused) {
                this.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.setBackground(null);
            }
        } else {
            this.setBackground(null);
        }
        if (value instanceof LoadingNode) {
            this.setForeground(Color.gray);
            this.setIcon(LOADING_NODE_ICON);
        } else {
            this.setForeground(tree.getForeground());
            this.setIcon(null);
        }
        if (UIUtil.isUnderNimbusLookAndFeel() && selected && hasFocus) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else {
            super.setOpaque(this.myOpaque || selected && hasFocus || selected && tree.hasFocus());
        }
        this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        if (this.getFont() == null) {
            this.setFont(tree.getFont());
        }
        return this;
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.myOpaque = isOpaque;
        super.setOpaque(isOpaque);
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/ColoredTreeCellRenderer.append must not be null");
        }
        if (attributes == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ui/ColoredTreeCellRenderer.append must not be null");
        }
        if (this.mySelected && (this.myFocused || UIUtil.isUnderNimbusLookAndFeel())) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTreeSelectionForeground()), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    public abstract void customizeCellRenderer(JTree var1, Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);
}

