/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    public static StringPattern string() {
        return new StringPattern();
    }

    public static CharPattern character() {
        return new CharPattern();
    }

    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass) {
        return new ObjectPattern.Capture<T>(aClass);
    }

    public static <T> ElementPattern save(final Key<T> key) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                context.put(key, o);
                return true;
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                builder.append("save(").append(key).append(")");
            }
        });
    }

    public static ObjectPattern.Capture<Object> object() {
        return StandardPatterns.instanceOf(Object.class);
    }

    public static <T> ObjectPattern.Capture<T> object(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StandardPatterns.object must not be null");
        }
        return (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
    }

    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        return new CollectionPattern();
    }

    public static ElementPattern get(final @NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StandardPatterns.get must not be null");
        }
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return Comparing.equal((Object)o, (Object)context.get(key));
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                builder.append("get(").append(key).append(")");
            }
        });
    }

    public static <T> CollectionPattern<T> collection() {
        return new CollectionPattern();
    }

    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.getCondition().accepts(o, context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }
        });
    }

    public static <E> ElementPattern<E> and(final ElementPattern<? extends E> ... patterns) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (pattern.getCondition().accepts(o, context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }
        });
    }

    public static <E> ElementPattern<E> not(final ElementPattern<E> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return !pattern.getCondition().accepts(o, context);
            }

            @Override
            public void append(@NonNls StringBuilder builder, String indent) {
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }
        });
    }

    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        return new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                pattern.getCondition().accepts(o, context);
                return true;
            }
        });
    }
}

