/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.pom.PomRenameableTarget;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiClassPattern
extends PsiMemberPattern<PsiClass, PsiClassPattern> {
    protected PsiClassPattern() {
        super(PsiClass.class);
    }

    public PsiClassPattern inheritorOf(final boolean strict, final PsiClassPattern pattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("inheritorOf"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiClassPattern$1.accepts must not be null");
                }
                return PsiClassPattern.isInheritor(strict ? psiClass.getSuperClass() : psiClass, pattern, context);
            }
        });
    }

    private static boolean isInheritor(PsiClass psiClass, ElementPattern pattern, ProcessingContext matchingContext) {
        if (psiClass == null) {
            return false;
        }
        if (pattern.getCondition().accepts(psiClass, matchingContext)) {
            return true;
        }
        if (PsiClassPattern.isInheritor(psiClass.getSuperClass(), pattern, matchingContext)) {
            return true;
        }
        for (PsiClass aClass : psiClass.getInterfaces()) {
            if (!PsiClassPattern.isInheritor(aClass, pattern, matchingContext)) continue;
            return true;
        }
        return false;
    }

    public PsiClassPattern inheritorOf(boolean strict, String className) {
        return this.inheritorOf(strict, PsiJavaPatterns.psiClass().withQualifiedName(className));
    }

    public PsiClassPattern isInterface() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("isInterface"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiClassPattern$2.accepts must not be null");
                }
                return psiClass.isInterface();
            }
        });
    }

    public PsiClassPattern withMember(final ElementPattern<? extends PsiMember> memberPattern) {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withMember"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiClassPattern$3.accepts must not be null");
                }
                for (PsiMethod psiMethod : psiClass.getMethods()) {
                    if (!memberPattern.accepts(psiMethod, context)) continue;
                    return true;
                }
                for (PomRenameableTarget<PsiElement> pomRenameableTarget : psiClass.getFields()) {
                    if (!memberPattern.accepts(pomRenameableTarget, context)) continue;
                    return true;
                }
                for (PomRenameableTarget<PsiElement> pomRenameableTarget : psiClass.getInnerClasses()) {
                    if (!memberPattern.accepts(pomRenameableTarget, context)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public PsiClassPattern nonAnnotationType() {
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("nonAnnotationType"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiClassPattern$4.accepts must not be null");
                }
                return !psiClass.isAnnotationType();
            }
        });
    }

    public PsiClassPattern withQualifiedName(final @NonNls @NotNull String qname) {
        if (qname == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiClassPattern.withQualifiedName must not be null");
        }
        return (PsiClassPattern)this.with(new PatternCondition<PsiClass>("withQualifiedName"){

            @Override
            public boolean accepts(@NotNull PsiClass psiClass, ProcessingContext context) {
                if (psiClass == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiClassPattern$5.accepts must not be null");
                }
                return qname.equals(psiClass.getQualifiedName());
            }
        });
    }
}

