/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.ui;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestFileConfiguration {
    private List<String> myClasspath;
    private String myMainClass;
    private String myManifestFilePath;

    public ManifestFileConfiguration(@NotNull ManifestFileConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/ui/ManifestFileConfiguration.<init> must not be null");
        }
        this.myClasspath = new ArrayList<String>();
        this.copyFrom(configuration);
    }

    public ManifestFileConfiguration(@NotNull String manifestFilePath, @Nullable List<String> classpath, @Nullable String mainClass) {
        if (manifestFilePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/ui/ManifestFileConfiguration.<init> must not be null");
        }
        this.myClasspath = new ArrayList<String>();
        if (classpath != null) {
            this.myClasspath.addAll(classpath);
        }
        this.myMainClass = mainClass;
        this.myManifestFilePath = manifestFilePath;
    }

    public void copyFrom(@NotNull ManifestFileConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/ui/ManifestFileConfiguration.copyFrom must not be null");
        }
        this.myClasspath.clear();
        this.myClasspath.addAll(configuration.getClasspath());
        this.myMainClass = configuration.getMainClass();
        this.myManifestFilePath = configuration.getManifestFilePath();
    }

    public List<String> getClasspath() {
        return this.myClasspath;
    }

    public void setClasspath(List<String> classpath) {
        this.myClasspath = classpath;
    }

    public String getMainClass() {
        return this.myMainClass;
    }

    public void setMainClass(String mainClass) {
        this.myMainClass = mainClass;
    }

    public String getManifestFilePath() {
        return this.myManifestFilePath;
    }

    public void setManifestFilePath(String manifestFilePath) {
        this.myManifestFilePath = manifestFilePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManifestFileConfiguration)) {
            return false;
        }
        ManifestFileConfiguration that = (ManifestFileConfiguration)o;
        if (!((Object)this.myClasspath).equals(that.myClasspath)) {
            return false;
        }
        if (this.myMainClass != null ? !this.myMainClass.equals(that.myMainClass) : that.myMainClass != null) {
            return false;
        }
        return !(this.myManifestFilePath != null ? !this.myManifestFilePath.equals(that.myManifestFilePath) : that.myManifestFilePath != null);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public void addToClasspath(List<String> classpath) {
        for (String path : classpath) {
            if (this.myClasspath.contains(path)) continue;
            this.myClasspath.add(path);
        }
    }
}

