/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.nio.charset.Charset;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EncodingManager
implements ApplicationComponent {
    @NonNls
    public static final String PROP_NATIVE2ASCII_SWITCH = "native2ascii";
    @NonNls
    public static final String PROP_PROPERTIES_FILES_ENCODING = "propertiesFilesEncoding";

    public static EncodingManager getInstance() {
        return ServiceManager.getService(EncodingManager.class);
    }

    @NotNull
    public abstract Collection<Charset> getFavorites();

    public abstract Charset getEncoding(@Nullable VirtualFile var1, boolean var2);

    public abstract void setEncoding(@Nullable VirtualFile var1, @Nullable Charset var2);

    public abstract boolean isUseUTFGuessing(VirtualFile var1);

    public abstract void setUseUTFGuessing(VirtualFile var1, boolean var2);

    public abstract boolean isNative2AsciiForPropertiesFiles(VirtualFile var1);

    public abstract void setNative2AsciiForPropertiesFiles(VirtualFile var1, boolean var2);

    public abstract Charset getDefaultCharset();

    public String getDefaultCharsetName() {
        return this.getDefaultCharset().displayName();
    }

    public void setDefaultCharsetName(String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public abstract Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile var1);

    public abstract void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile var1, @Nullable Charset var2);

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract Charset getCachedCharsetFromContent(@NotNull Document var1);
}

