/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.process.InterruptibleActivity;
import com.intellij.openapi.util.process.ProcessCloseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;

public abstract class InterruptibleProcess
extends InterruptibleActivity {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.util.process.InterruptibleProcess");
    private final Process myProcess;
    private final InputStream myInputStream;
    private final InputStream myErrorStream;
    private int myExitCode;
    private boolean myDestroyed;

    protected InterruptibleProcess(Process process, long timeout, TimeUnit timeUnit) {
        super(timeout, timeUnit);
        this.myProcess = process;
        this.myInputStream = new InputStreamWrapper(process.getInputStream());
        this.myErrorStream = new InputStreamWrapper(process.getErrorStream());
    }

    public final InputStream getErrorStream() {
        return this.myErrorStream;
    }

    public final InputStream getInputStream() {
        return this.myInputStream;
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    @Override
    protected void interrupt() {
        this.closeProcess();
    }

    public static void close(Process process) {
        ProcessCloseUtil.close(process);
    }

    public void closeProcess() {
        if (this.myDestroyed) {
            return;
        }
        this.myDestroyed = true;
        InterruptibleProcess.close(this.myProcess);
    }

    @Override
    protected void start() {
        try {
            this.myExitCode = this.myProcess.waitFor();
        }
        catch (InterruptedException e) {
            LOG.debug((Throwable)e);
        }
    }

    private class InputStreamWrapper
    extends InputStream {
        private final InputStream myDelegate;

        public InputStreamWrapper(InputStream delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public int read() throws IOException {
            int r = this.myDelegate.read();
            InterruptibleProcess.this.touch();
            return r;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int r = this.myDelegate.read(b);
            InterruptibleProcess.this.touch();
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.myDelegate.read(b, off, len);
            InterruptibleProcess.this.touch();
            return r;
        }

        @Override
        public void close() throws IOException {
            this.myDelegate.close();
        }
    }
}

