/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public interface BusyObject {
    public ActionCallback getReady(Object var1);

    public static abstract class Impl
    implements BusyObject {
        private final Map<Object, ActionCallback> myReadyCallbacks = new WeakHashMap<Object, ActionCallback>();

        protected abstract boolean isReady();

        public final void onReady() {
            ActionCallback[] ready;
            for (ActionCallback each : ready = this.getReadyCallbacks(true)) {
                if (each == null) continue;
                each.setDone();
            }
        }

        @Override
        public final ActionCallback getReady(Object requestor) {
            if (this.isReady()) {
                return new ActionCallback.Done();
            }
            return this.addReadyCallback(requestor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ActionCallback addReadyCallback(Object requestor) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            synchronized (map) {
                ActionCallback cb = this.myReadyCallbacks.get(requestor);
                if (cb == null) {
                    cb = new ActionCallback();
                    this.myReadyCallbacks.put(requestor, cb);
                }
                return cb;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ActionCallback[] getReadyCallbacks(boolean clear) {
            Map<Object, ActionCallback> map = this.myReadyCallbacks;
            synchronized (map) {
                ActionCallback[] result = this.myReadyCallbacks.values().toArray(new ActionCallback[this.myReadyCallbacks.size()]);
                if (clear) {
                    this.myReadyCallbacks.clear();
                }
                return result;
            }
        }

        public static class Simple
        extends Impl {
            private AtomicInteger myBusyCount = new AtomicInteger();

            @Override
            protected boolean isReady() {
                return this.myBusyCount.get() == 0;
            }

            public ActionCallback execute(ActiveRunnable runnable) {
                this.myBusyCount.addAndGet(1);
                ActionCallback cb = runnable.run();
                cb.doWhenProcessed(new Runnable(){

                    @Override
                    public void run() {
                        Simple.this.myBusyCount.addAndGet(-1);
                        if (Simple.this.isReady()) {
                            Simple.this.onReady();
                        }
                    }
                });
                return cb;
            }
        }
    }
}

