/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.ui.Banner;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.Nullable;

public class DetailsComponent {
    private final JPanel myComponent;
    private JComponent myContent;
    private final Banner myBannerLabel;
    private final JLabel myEmptyContentLabel;
    private final NonOpaquePanel myBanner;
    private String[] myBannerText;
    private boolean myDetailsEnabled = true;
    private String[] myPrefix;
    private String[] myText;
    private final Wrapper myContentGutter = new Wrapper();
    private boolean myPaintBorder = true;

    public DetailsComponent() {
        this.myComponent = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                if (NullableComponent.Check.isNull((Component)DetailsComponent.this.myContent) || !DetailsComponent.this.myDetailsEnabled) {
                    return;
                }
                GraphicsConfig c = new GraphicsConfig(g);
                c.setAntialiasing(true);
                int arc = 8;
                Insets insets = this.getInsets();
                if (insets == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                g.setColor(UIUtil.getFocusedFillColor());
                Rectangle banner = DetailsComponent.this.myBanner.getBounds();
                GeneralPath header = new GeneralPath();
                int leftX = insets.left;
                int leftY = insets.top;
                int rightX = insets.left + this.getWidth() - 1 - insets.right;
                int rightY = banner.y + banner.height;
                header.moveTo(leftX, rightY);
                header.lineTo(leftX, leftY + arc);
                header.quadTo(leftX, leftY, leftX + arc, leftY);
                header.lineTo(rightX - arc, leftY);
                header.quadTo(rightX, leftY, rightX, leftY + arc);
                header.lineTo(rightX, rightY);
                header.closePath();
                c.getG().fill(header);
                g.setColor(UIUtil.getFocusedBoundsColor());
                c.getG().draw(header);
                if (DetailsComponent.this.myPaintBorder) {
                    int down = this.getHeight() - insets.top - insets.bottom - 1;
                    g.drawLine(leftX, rightY, leftX, down);
                    g.drawLine(rightX, rightY, rightX, down);
                    g.drawLine(leftX, down, rightX, down);
                }
                c.restore();
            }
        };
        this.myComponent.setOpaque(false);
        this.myContentGutter.setOpaque(false);
        this.myContentGutter.setBorder(null);
        this.myBanner = new NonOpaquePanel(new BorderLayout());
        this.myBannerLabel = new Banner();
        this.myBanner.add((Component)this.myBannerLabel, "Center");
        this.myEmptyContentLabel = new JLabel("", 0);
        this.revalidateDetailsMode();
    }

    private void revalidateDetailsMode() {
        this.myComponent.removeAll();
        this.myComponent.add((Component)this.myContentGutter, "Center");
        if (this.myDetailsEnabled) {
            this.myComponent.add((Component)this.myBanner, "North");
        }
        if (this.myContent != null) {
            this.myContentGutter.add((Component)this.myContent, "Center");
            this.invalidateContentBorder();
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setBannerActions(Action[] actions) {
        this.myBannerLabel.clearActions();
        for (Action each : actions) {
            this.myBannerLabel.addAction(each);
        }
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    public void setContent(@Nullable JComponent c) {
        if (this.myContent != null) {
            this.myContentGutter.remove(this.myContent);
        }
        this.myContent = new MyWrapper(c);
        this.myContent.setOpaque(false);
        this.invalidateContentBorder();
        this.myContentGutter.add((Component)this.myContent, "Center");
        this.updateBanner();
        this.myComponent.revalidate();
        this.myComponent.repaint();
    }

    private void invalidateContentBorder() {
        if (this.myDetailsEnabled) {
            this.myContent.setBorder(new EmptyBorder(5, 5, 5, 5));
        } else {
            this.myContent.setBorder(null);
        }
    }

    public void setPrefix(String ... prefix) {
        this.myPrefix = prefix;
        if (this.myText != null) {
            this.setText(this.myText);
        }
    }

    public void setText(String ... text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/DetailsComponent.setText must not be null");
        }
        this.myText = text;
        this.update();
    }

    public void update() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.myPrefix != null) {
            strings.addAll(Arrays.asList(this.myPrefix));
        }
        if (this.myText != null) {
            strings.addAll(Arrays.asList(this.myText));
        }
        this.myBannerText = ArrayUtil.toStringArray(strings);
        this.updateBanner();
    }

    private void updateBanner() {
        if (NullableComponent.Check.isNull((Component)this.myContent)) {
            this.myBannerLabel.setText(null);
        } else {
            this.myBannerLabel.setText(this.myBannerText);
        }
        this.myBannerLabel.revalidate();
        this.myBannerLabel.repaint();
    }

    public void setPaintBorder(boolean paintBorder) {
        this.myPaintBorder = paintBorder;
    }

    public DetailsComponent setEmptyContentText(@Nullable String emptyContentText) {
        String s = "<html><body><center>" + (emptyContentText != null ? emptyContentText : "") + "</center></body><html>";
        this.myEmptyContentLabel.setText(s);
        return this;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getContentGutter() {
        return this.myContentGutter;
    }

    public void setBannerMinHeight(int height) {
        this.myBannerLabel.setMinHeight(height);
    }

    public void disposeUIResources() {
        this.setContent(null);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel content = new JPanel(new BorderLayout());
        final DetailsComponent d = new DetailsComponent();
        content.add((Component)d.getComponent(), "Center");
        d.setText("This is a Tree");
        JTree c = new JTree();
        c.setBorder(new LineBorder(Color.red));
        d.setContent(c);
        frame.getContentPane().add((Component)content, "Center");
        final JCheckBox details = new JCheckBox("Details");
        details.setSelected(true);
        frame.getContentPane().add((Component)details, "South");
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.setDetailsModeEnabled(details.isSelected());
            }
        });
        frame.setBounds(300, 300, 300, 300);
        frame.show();
    }

    public void updateBannerActions() {
        this.myBannerLabel.updateActions();
    }

    public void setDetailsModeEnabled(boolean enabled) {
        if (this.myDetailsEnabled == enabled) {
            return;
        }
        this.myDetailsEnabled = enabled;
        this.revalidateDetailsMode();
    }

    private class MyWrapper
    extends Wrapper
    implements NullableComponent {
        public MyWrapper(JComponent c) {
            super(c == null || NullableComponent.Check.isNull((Component)c) ? DetailsComponent.this.myEmptyContentLabel : c);
        }

        @Override
        public boolean isNull() {
            return this.getTargetComponent() == DetailsComponent.this.myEmptyContentLabel;
        }
    }

    public static interface Facade {
        public DetailsComponent getDetailsComponent();
    }
}

