/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.util.CellAppearance;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.roots.ui.util.ModifiableCellAppearance;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SimpleTextCellAppearance
implements ModifiableCellAppearance {
    private Icon myIcon;
    private final SimpleTextAttributes myTextAttributes;
    private final String myText;

    public static SimpleTextCellAppearance invalid(String text, Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.ERROR_ATTRIBUTES);
    }

    public static CellAppearance normal(String text, Icon icon) {
        CompositeAppearance result = CompositeAppearance.single(text);
        result.setIcon(icon);
        return result;
    }

    public SimpleTextCellAppearance(@NotNull String text, Icon icon, SimpleTextAttributes textAttributes) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/util/SimpleTextCellAppearance.<init> must not be null");
        }
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
        this.myText = text;
    }

    @Override
    public void customize(SimpleColoredComponent component) {
        component.setIcon(this.myIcon);
        component.append(this.myText, this.myTextAttributes);
    }

    @Override
    public String getText() {
        return this.myText;
    }

    public SimpleTextAttributes getTextAttributes() {
        return this.myTextAttributes;
    }

    public static SimpleTextCellAppearance syntetic(String text, Icon icon) {
        return new SimpleTextCellAppearance(text, icon, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES);
    }

    @Override
    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }
}

