/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.util;

import com.intellij.openapi.roots.ui.util.CellAppearance;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;

public abstract class BaseTextCommentCellAppearance
implements CellAppearance {
    private SimpleTextAttributes myCommentAttributes = SimpleTextAttributes.GRAY_ATTRIBUTES;
    private SimpleTextAttributes myTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;

    protected abstract Icon getIcon();

    protected abstract String getSecondaryText();

    protected abstract String getPrimaryText();

    @Override
    public void customize(SimpleColoredComponent component) {
        component.setIcon(this.getIcon());
        component.append(this.getPrimaryText(), this.myTextAttributes);
        String secondaryText = this.getSecondaryText();
        if (secondaryText != null && secondaryText.length() > 0) {
            component.append(" (" + secondaryText + ")", this.myCommentAttributes);
        }
    }

    @Override
    public String getText() {
        String secondaryText = this.getSecondaryText();
        if (secondaryText != null && secondaryText.length() > 0) {
            return this.getPrimaryText() + " (" + secondaryText + ")";
        }
        return this.getPrimaryText();
    }

    public void setCommentAttributes(SimpleTextAttributes commentAttributes) {
        this.myCommentAttributes = commentAttributes;
    }

    public void setTextAttributes(SimpleTextAttributes textAttributes) {
        this.myTextAttributes = textAttributes;
    }
}

