/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.SdkVersionUtil;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaSdk
extends SdkType
implements JavaSdkType,
ApplicationComponent {
    public JavaSdk(@NonNls String name) {
        super(name);
    }

    public static JavaSdk getInstance() {
        return ApplicationManager.getApplication().getComponent(JavaSdk.class);
    }

    public final Sdk createJdk(String jdkName, String jreHome) {
        return this.createJdk(jdkName, jreHome, true);
    }

    public abstract int compareTo(@NotNull String var1, @NotNull String var2);

    public abstract Sdk createJdk(@NonNls String var1, String var2, boolean var3);

    public static boolean checkForJdk(File file) {
        return JdkUtil.checkForJdk(file);
    }

    public static boolean checkForJre(String file) {
        return JdkUtil.checkForJre(file);
    }

    @Nullable
    public static String getJdkVersion(String sdkHome) {
        return SdkVersionUtil.readVersionFromProcessOutput(sdkHome, new String[]{sdkHome + File.separator + "bin" + File.separator + "java", "-version"}, "version");
    }
}

