/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.LinkedList;
import java.util.Queue;

public abstract class AbstractTaskQueue<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.AbstractTaskQueue");
    private final Object myLock = new Object();
    private final Queue<T> myQueue = new LinkedList<T>();
    private boolean myActive = false;
    protected final Runnable myQueueWorker = new MyWorker();

    protected abstract void runMe();

    protected abstract void runStuff(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(T stuff) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runStuff(stuff);
            return;
        }
        boolean impulseGiven = false;
        Object object = this.myLock;
        synchronized (object) {
            try {
                this.myQueue.add(stuff);
                if (!this.myActive) {
                    this.runMe();
                    impulseGiven = true;
                }
            }
            catch (Throwable t) {
                LOG.info(t);
                throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
            }
            finally {
                if (!this.myActive && impulseGiven) {
                    this.myActive = true;
                }
            }
        }
    }

    private class MyWorker
    implements Runnable {
        private MyWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object stuff;
                try {
                    Object object = AbstractTaskQueue.this.myLock;
                    synchronized (object) {
                        stuff = AbstractTaskQueue.this.myQueue.poll();
                    }
                    AbstractTaskQueue.this.runStuff(stuff);
                    continue;
                }
                catch (Throwable t) {
                    LOG.info(t);
                    continue;
                }
                finally {
                    stuff = AbstractTaskQueue.this.myLock;
                    synchronized (stuff) {
                        if (AbstractTaskQueue.this.myQueue.isEmpty()) {
                            AbstractTaskQueue.this.myActive = false;
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
    }
}

