/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.MockFileTypeManager;
import com.intellij.openapi.fileTypes.WildcardFileNameMatcher;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTypeManager {
    public static FileTypeManager getInstance() {
        return FileTypeManagerHolder.ourInstance;
    }

    private static FileTypeManager createFileTypeManager() {
        Application app = ApplicationManager.getApplication();
        return app == null ? new MockFileTypeManager() : app.getComponent(FileTypeManager.class);
    }

    public abstract void registerFileType(@NotNull FileType var1, @NotNull List<FileNameMatcher> var2);

    public final void registerFileType(@NotNull FileType type, String ... defaultAssociatedExtensions) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.registerFileType must not be null");
        }
        ArrayList<FileNameMatcher> matchers = new ArrayList<FileNameMatcher>();
        if (defaultAssociatedExtensions != null) {
            for (String extension : defaultAssociatedExtensions) {
                matchers.add(new ExtensionFileNameMatcher(extension));
            }
        }
        this.registerFileType(type, matchers);
    }

    @NotNull
    public abstract FileType getFileTypeByFileName(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileType getFileTypeByFile(@NotNull VirtualFile var1);

    @NotNull
    public abstract FileType getFileTypeByExtension(@NonNls @NotNull String var1);

    @NotNull
    public abstract FileType[] getRegisteredFileTypes();

    public abstract boolean isFileIgnored(@NonNls @NotNull String var1);

    @NotNull
    public abstract String[] getAssociatedExtensions(@NotNull FileType var1);

    @NotNull
    public abstract List<FileNameMatcher> getAssociations(@NotNull FileType var1);

    public abstract boolean isFileOfType(VirtualFile var1, FileType var2);

    public abstract void addFileTypeListener(@NotNull FileTypeListener var1);

    public abstract void removeFileTypeListener(@NotNull FileTypeListener var1);

    @Nullable
    public abstract FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile var1);

    @NotNull
    public abstract String getIgnoredFilesList();

    public abstract void setIgnoredFilesList(@NotNull String var1);

    public final void associateExtension(@NotNull FileType type, @NotNull @NonNls String extension) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.associateExtension must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.associateExtension must not be null");
        }
        this.associate(type, new ExtensionFileNameMatcher(extension));
    }

    public final void associatePattern(@NotNull FileType type, @NotNull @NonNls String pattern) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.associatePattern must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.associatePattern must not be null");
        }
        this.associate(type, FileTypeManager.parseFromString(pattern));
    }

    public abstract void associate(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    public final void removeAssociatedExtension(@NotNull FileType type, @NotNull @NonNls String extension) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.removeAssociatedExtension must not be null");
        }
        if (extension == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileTypes/FileTypeManager.removeAssociatedExtension must not be null");
        }
        this.removeAssociation(type, new ExtensionFileNameMatcher(extension));
    }

    public abstract void removeAssociation(@NotNull FileType var1, @NotNull FileNameMatcher var2);

    public static FileNameMatcher parseFromString(String pattern) {
        if (pattern.startsWith("*.") && pattern.indexOf(42, 2) < 0 && pattern.indexOf(46, 2) < 0 && pattern.indexOf(63, 2) < 0) {
            return new ExtensionFileNameMatcher(pattern.substring(2).toLowerCase());
        }
        if (pattern.contains("*") || pattern.contains("?")) {
            return new WildcardFileNameMatcher(pattern);
        }
        return new ExactFileNameMatcher(pattern);
    }

    @NotNull
    public abstract FileType getStdFileType(@NotNull @NonNls String var1);

    static /* synthetic */ FileTypeManager access$000() {
        return FileTypeManager.createFileTypeManager();
    }

    private static class FileTypeManagerHolder {
        private static final FileTypeManager ourInstance = FileTypeManager.access$000();

        private FileTypeManagerHolder() {
        }
    }
}

