/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionValidator {
    public static final ExtensionPointName<InspectionValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.compiler.inspectionValidator");
    private final String myDescription;
    private final String myProgressIndicatorText;
    private final Class<? extends LocalInspectionTool>[] myInspectionToolClasses;

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, Class<? extends LocalInspectionTool> ... inspectionToolClasses) {
        if (description == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.<init> must not be null");
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.<init> must not be null");
        }
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = inspectionToolClasses;
    }

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, InspectionToolProvider provider) {
        if (description == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.<init> must not be null");
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.<init> must not be null");
        }
        this(description, progressIndicatorText, provider.getInspectionClasses());
    }

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, Class<? extends InspectionToolProvider> providerClass) throws IllegalAccessException, InstantiationException {
        if (description == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.<init> must not be null");
        }
        if (progressIndicatorText == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.<init> must not be null");
        }
        this(description, progressIndicatorText, providerClass.newInstance());
    }

    public abstract boolean isAvailableOnScope(@NotNull CompileScope var1);

    public abstract Collection<VirtualFile> getFilesToProcess(Project var1, CompileContext var2);

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/compiler/util/InspectionValidator.getDependencies must not return null");
        }
        return list;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        if (this.myInspectionToolClasses == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/compiler/util/InspectionValidator.getInspectionToolClasses must not return null");
        }
        return this.myInspectionToolClasses;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final String getProgressIndicatorText() {
        return this.myProgressIndicatorText;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        if (severity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.getCategoryByHighlightDisplayLevel must not be null");
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.getCategoryByHighlightDisplayLevel must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/compiler/util/InspectionValidator.getCategoryByHighlightDisplayLevel must not be null");
        }
        if (severity == HighlightDisplayLevel.ERROR) {
            return CompilerMessageCategory.ERROR;
        }
        if (severity == HighlightDisplayLevel.WARNING) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.INFORMATION;
    }
}

