/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.Nullable;

public abstract class UndoManager {
    public static final Key<Boolean> DONT_RECORD_UNDO = Key.create((String)"DONT_RECORD_UNDO");

    public static UndoManager getInstance(Project project) {
        return project.getComponent(UndoManager.class);
    }

    public static UndoManager getGlobalInstance() {
        return ApplicationManager.getApplication().getComponent(UndoManager.class);
    }

    public abstract void undoableActionPerformed(UndoableAction var1);

    public abstract void nonundoableActionPerformed(DocumentReference var1, boolean var2);

    public abstract boolean isUndoInProgress();

    public abstract boolean isRedoInProgress();

    public abstract void undo(@Nullable FileEditor var1);

    public abstract void redo(@Nullable FileEditor var1);

    public abstract boolean isUndoAvailable(@Nullable FileEditor var1);

    public abstract boolean isRedoAvailable(@Nullable FileEditor var1);

    @Nullable
    public abstract String formatAvailableUndoAction(@Nullable FileEditor var1);

    @Nullable
    public abstract String formatAvailableRedoAction(@Nullable FileEditor var1);
}

