/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.Balloon;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.Notification");
    private String myGroupId;
    private String myContent;
    private NotificationType myType;
    private NotificationListener myListener;
    private String myTitle;
    private boolean myExpired;
    private WeakReference<Balloon> myBalloonRef;

    public Notification(@NotNull String groupId, @NotNull String title, @NotNull String content, @NotNull NotificationType type) {
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        this.myGroupId = groupId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
    }

    public Notification(@NotNull String groupId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupId == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/notification/Notification.<init> must not be null");
        }
        this(groupId, title, content, type);
        this.myListener = listener;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/Notification.getGroupId must not return null");
        }
        return string;
    }

    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public String getContent() {
        LOG.assertTrue(this.myContent.trim().length() > 0, (Object)"Notification should have content!");
        String string = this.myContent;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/Notification.getContent must not return null");
        }
        return string;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public NotificationType getType() {
        NotificationType notificationType = this.myType;
        if (notificationType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/notification/Notification.getType must not return null");
        }
        return notificationType;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public void expire() {
        NotificationsManager.getNotificationsManager().expire(this);
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
        this.myExpired = true;
    }

    public void setBalloon(@Nullable Balloon balloon) {
        this.myBalloonRef = balloon != null ? new WeakReference<Balloon>(balloon) : null;
    }

    @Nullable
    public Balloon getBalloon() {
        return this.myBalloonRef == null ? null : (Balloon)this.myBalloonRef.get();
    }
}

