/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerPositionImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LayeredLexer
extends DelegateLexer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.LayeredLexer");
    private static final int IN_LAYER_STATE = 1024;
    private int myState;
    private final Map<IElementType, Lexer> myStartTokenToLayerLexer = new HashMap();
    private Lexer myCurrentLayerLexer;
    private final HashSet<Lexer> mySelfStoppingLexers = new HashSet(1);
    private final HashMap<Lexer, IElementType[]> myStopTokens = new HashMap(1);

    public LayeredLexer(Lexer baseLexer) {
        super(baseLexer);
    }

    public void registerSelfStoppingLayer(Lexer Lexer2, IElementType[] startTokens, IElementType[] stopTokens) {
        this.registerLayer(Lexer2, startTokens);
        this.mySelfStoppingLexers.add(Lexer2);
        this.myStopTokens.put((Object)Lexer2, (Object)stopTokens);
    }

    public void registerLayer(Lexer Lexer2, IElementType ... startTokens) {
        for (IElementType startToken : startTokens) {
            LOG.assertTrue(!this.myStartTokenToLayerLexer.containsKey(startToken));
            this.myStartTokenToLayerLexer.put(startToken, Lexer2);
        }
    }

    private void activateLayerIfNecessary() {
        Lexer base = this.getDelegate();
        this.myCurrentLayerLexer = this.myStartTokenToLayerLexer.get(base.getTokenType());
        if (this.myCurrentLayerLexer != null) {
            this.myCurrentLayerLexer.start(base.getBufferSequence(), base.getTokenStart(), base.getTokenEnd());
            if (this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                base.advance();
            }
        }
    }

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        LOG.assertTrue(initialState != 1024, (Object)"Restoring to layer is not supported.");
        this.myState = initialState;
        this.myCurrentLayerLexer = null;
        super.start(buffer, startOffset, endOffset, initialState);
        this.activateLayerIfNecessary();
    }

    @Override
    public int getState() {
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenType() : super.getTokenType();
    }

    @Override
    public int getTokenStart() {
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenStart() : super.getTokenStart();
    }

    @Override
    public int getTokenEnd() {
        return this.isLayerActive() ? this.myCurrentLayerLexer.getTokenEnd() : super.getTokenEnd();
    }

    @Override
    public void advance() {
        if (this.isLayerActive()) {
            IElementType layerTokenType = this.myCurrentLayerLexer.getTokenType();
            if (!this.isStopToken(this.myCurrentLayerLexer, layerTokenType)) {
                this.myCurrentLayerLexer.advance();
                layerTokenType = this.myCurrentLayerLexer.getTokenType();
            } else {
                layerTokenType = null;
            }
            if (layerTokenType == null) {
                int tokenEnd = this.myCurrentLayerLexer.getTokenEnd();
                if (!this.mySelfStoppingLexers.contains(this.myCurrentLayerLexer)) {
                    this.myCurrentLayerLexer = null;
                    super.advance();
                    this.activateLayerIfNecessary();
                } else {
                    this.myCurrentLayerLexer = null;
                }
            }
        } else {
            super.advance();
            this.activateLayerIfNecessary();
        }
        this.myState = this.isLayerActive() ? 1024 : super.getState();
    }

    @Override
    public LexerPosition getCurrentPosition() {
        return new LexerPositionImpl(this.getTokenStart(), this.getState());
    }

    @Override
    public void restore(LexerPosition position) {
        this.start(this.getBufferSequence(), position.getOffset(), this.getBufferEnd(), position.getState());
    }

    private boolean isStopToken(Lexer lexer, IElementType tokenType) {
        IElementType[] stopTokens = (IElementType[])this.myStopTokens.get((Object)lexer);
        if (stopTokens == null) {
            return false;
        }
        for (IElementType stopToken : stopTokens) {
            if (stopToken != tokenType) continue;
            return true;
        }
        return false;
    }

    private boolean isLayerActive() {
        return this.myCurrentLayerLexer != null;
    }
}

