/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;

public class FlexAdapter
extends LexerBase {
    private FlexLexer myFlex = null;
    private IElementType myTokenType = null;
    private CharSequence myText;
    private int myEnd;
    private int myState;

    public FlexAdapter(FlexLexer flex) {
        this.myFlex = flex;
    }

    public FlexLexer getFlex() {
        return this.myFlex;
    }

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myText = buffer;
        this.myEnd = endOffset;
        try {
            this.myFlex.reset(this.myText, startOffset, endOffset, initialState);
        }
        catch (AbstractMethodError ame) {
            this.myFlex.reset(this.myText.subSequence(startOffset, endOffset), initialState);
        }
        this.myTokenType = null;
    }

    @Override
    public int getState() {
        this.locateToken();
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        this.locateToken();
        return this.myFlex.getTokenStart();
    }

    @Override
    public int getTokenEnd() {
        this.locateToken();
        return this.myFlex.getTokenEnd();
    }

    @Override
    public void advance() {
        this.locateToken();
        this.myTokenType = null;
    }

    @Override
    public CharSequence getBufferSequence() {
        return this.myText;
    }

    @Override
    public int getBufferEnd() {
        return this.myEnd;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        try {
            this.myState = this.myFlex.yystate();
            this.myTokenType = this.myFlex.advance();
        }
        catch (IOException e) {
        }
        catch (Error e) {
            Error error = new Error(this.myFlex.getClass().getName() + ": " + e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }
}

