/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.util.AsyncResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructure {
    public abstract Object getRootElement();

    public abstract Object[] getChildElements(Object var1);

    @Nullable
    public abstract Object getParentElement(Object var1);

    @NotNull
    public abstract NodeDescriptor createDescriptor(Object var1, NodeDescriptor var2);

    public abstract void commit();

    public abstract boolean hasSomethingToCommit();

    public boolean isToBuildChildrenInBackground(Object element) {
        return false;
    }

    public boolean isAlwaysLeaf(Object element) {
        return false;
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        return new AsyncResult.Done<Object>(element);
    }

    public static class Delegate
    extends AbstractTreeStructure {
        private AbstractTreeStructure myDelegee;

        public Delegate(AbstractTreeStructure delegee) {
            this.myDelegee = delegee;
        }

        @Override
        public Object getRootElement() {
            return this.myDelegee.getRootElement();
        }

        @Override
        public Object[] getChildElements(Object element) {
            return this.myDelegee.getChildElements(element);
        }

        @Override
        public Object getParentElement(Object element) {
            return this.myDelegee.getParentElement(element);
        }

        @Override
        @NotNull
        public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
            NodeDescriptor nodeDescriptor = this.myDelegee.createDescriptor(element, parentDescriptor);
            if (nodeDescriptor == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/util/treeView/AbstractTreeStructure$Delegate.createDescriptor must not return null");
            }
            return nodeDescriptor;
        }

        @Override
        public void commit() {
            this.myDelegee.commit();
        }

        @Override
        public boolean hasSomethingToCommit() {
            return this.myDelegee.hasSomethingToCommit();
        }

        @Override
        public boolean isToBuildChildrenInBackground(Object element) {
            return this.myDelegee.isToBuildChildrenInBackground(element);
        }

        @Override
        public boolean isAlwaysLeaf(Object element) {
            return this.myDelegee.isAlwaysLeaf(element);
        }

        public AsyncResult revalidateElement(Object element) {
            return this.myDelegee.revalidateElement(element);
        }

        public AbstractTreeStructure getOriginalStructure() {
            return this.myDelegee;
        }
    }
}

