/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardContext {
    @Nullable
    private final Project myProject;
    private String myProjectFileDirectory;
    private String myProjectName;
    private String myCompilerOutputDirectory;
    private Sdk myProjectJdk;
    private ProjectBuilder myProjectBuilder;
    private final List<Listener> myListeners = new ArrayList<Listener>();
    private StorageScheme myProjectStorageFormat = StorageScheme.DEFAULT;

    public void setProjectStorageFormat(StorageScheme format) {
        this.myProjectStorageFormat = format;
    }

    public WizardContext(Project project) {
        this.myProject = project;
        if (this.myProject != null) {
            this.myProjectJdk = ProjectRootManager.getInstance(this.myProject).getProjectJdk();
        }
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getProjectFileDirectory() {
        String string;
        if (this.myProjectFileDirectory != null) {
            string = this.myProjectFileDirectory;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/WizardContext.getProjectFileDirectory must not return null");
            return string;
        }
        String lastProjectLocation = GeneralSettings.getInstance().getLastProjectLocation();
        if (lastProjectLocation != null) {
            string = lastProjectLocation.replace('/', File.separatorChar);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/WizardContext.getProjectFileDirectory must not return null");
            return string;
        }
        String userHome = SystemProperties.getUserHome();
        string = userHome.replace('/', File.separatorChar) + File.separator + ApplicationNamesInfo.getInstance().getLowercaseProductName() + "Projects";
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/ide/util/projectWizard/WizardContext.getProjectFileDirectory must not return null");
    }

    public void setProjectFileDirectory(String projectFileDirectory) {
        this.myProjectFileDirectory = projectFileDirectory;
    }

    public String getCompilerOutputDirectory() {
        return this.myCompilerOutputDirectory;
    }

    public void setCompilerOutputDirectory(String compilerOutputDirectory) {
        this.myCompilerOutputDirectory = compilerOutputDirectory;
    }

    public String getProjectName() {
        return this.myProjectName;
    }

    public void setProjectName(String projectName) {
        this.myProjectName = projectName;
    }

    public boolean isCreatingNewProject() {
        return this.myProject == null;
    }

    public void requestWizardButtonsUpdate() {
        Listener[] listeners;
        for (Listener listener : listeners = this.myListeners.toArray(new Listener[this.myListeners.size()])) {
            listener.buttonsUpdateRequested();
        }
    }

    public void requestNextStep() {
        Listener[] listeners;
        for (Listener listener : listeners = this.myListeners.toArray(new Listener[this.myListeners.size()])) {
            listener.nextStepRequested();
        }
    }

    public void addContextListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void removeContextListener(Listener listener) {
        this.myListeners.remove(listener);
    }

    public void setProjectJdk(Sdk jdk) {
        this.myProjectJdk = jdk;
    }

    public Sdk getProjectJdk() {
        return this.myProjectJdk;
    }

    public ProjectBuilder getProjectBuilder() {
        return this.myProjectBuilder;
    }

    public void setProjectBuilder(ProjectBuilder projectBuilder) {
        this.myProjectBuilder = projectBuilder;
    }

    public String getPresentationName() {
        return this.myProject == null ? IdeBundle.message("project.new.wizard.project.identification", new Object[0]) : IdeBundle.message("project.new.wizard.module.identification", new Object[0]);
    }

    public StorageScheme getProjectStorageFormat() {
        return this.myProjectStorageFormat;
    }

    public static interface Listener {
        public void buttonsUpdateRequested();

        public void nextStepRequested();
    }
}

