/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class JavaModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private String myContentEntryPath;
    private String myCompilerOutputPath;
    private List<Pair<String, String>> mySourcePaths;
    private final List<Pair<String, String>> myModuleLibraries = new ArrayList<Pair<String, String>>();
    private Sdk myJdk;

    @Override
    @Nullable
    public final String getContentEntryPath() {
        if (this.myContentEntryPath == null) {
            String directory = this.getModuleFileDirectory();
            new File(directory).mkdirs();
            return directory;
        }
        return this.myContentEntryPath;
    }

    @Override
    public final void setContentEntryPath(String moduleRootPath) {
        String path = this.acceptParameter(moduleRootPath);
        if (path != null) {
            try {
                this.myContentEntryPath = FileUtil.resolveShortWindowsName((String)path);
            }
            catch (IOException e) {
                this.myContentEntryPath = path;
            }
        } else {
            this.myContentEntryPath = null;
        }
        if (this.myContentEntryPath != null) {
            this.myContentEntryPath = this.myContentEntryPath.replace(File.separatorChar, '/');
        }
    }

    public final void setCompilerOutputPath(String compilerOutputPath) {
        this.myCompilerOutputPath = this.acceptParameter(compilerOutputPath);
    }

    @Override
    public List<Pair<String, String>> getSourcePaths() {
        if (this.mySourcePaths == null) {
            ArrayList<Pair<String, String>> paths = new ArrayList<Pair<String, String>>();
            String path = this.getContentEntryPath() + File.separator + "src";
            new File(path).mkdirs();
            paths.add(Pair.create((Object)path, (Object)""));
            return paths;
        }
        return this.mySourcePaths;
    }

    @Override
    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
        this.mySourcePaths = sourcePaths != null ? new ArrayList<Pair<String, String>>(sourcePaths) : null;
    }

    @Override
    public void addSourcePath(Pair<String, String> sourcePathInfo) {
        if (this.mySourcePaths == null) {
            this.mySourcePaths = new ArrayList<Pair<String, String>>();
        }
        this.mySourcePaths.add(sourcePathInfo);
    }

    @Override
    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @Override
    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        LocalFileSystem lfs;
        VirtualFile moduleContentRoot;
        CompilerModuleExtension compilerModuleExtension = rootModel.getModuleExtension(CompilerModuleExtension.class);
        compilerModuleExtension.setExcludeOutput(true);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        String moduleRootPath = this.getContentEntryPath();
        if (moduleRootPath != null && (moduleContentRoot = (lfs = LocalFileSystem.getInstance()).refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)moduleRootPath))) != null) {
            ContentEntry contentEntry = rootModel.addContentEntry(moduleContentRoot);
            List<Pair<String, String>> sourcePaths = this.getSourcePaths();
            if (sourcePaths != null) {
                for (Pair<String, String> sourcePath : sourcePaths) {
                    VirtualFile sourceRoot = lfs.refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)((String)sourcePath.first)));
                    if (sourceRoot == null) continue;
                    contentEntry.addSourceFolder(sourceRoot, false, (String)sourcePath.second);
                }
            }
        }
        if (this.myCompilerOutputPath != null) {
            String canonicalPath;
            try {
                canonicalPath = FileUtil.resolveShortWindowsName((String)this.myCompilerOutputPath);
            }
            catch (IOException e) {
                canonicalPath = this.myCompilerOutputPath;
            }
            compilerModuleExtension.setCompilerOutputPath(VfsUtil.pathToUrl(FileUtil.toSystemIndependentName((String)canonicalPath)));
        } else {
            compilerModuleExtension.inheritCompilerOutputPath(true);
        }
        LibraryTable libraryTable = rootModel.getModuleLibraryTable();
        for (Pair<String, String> libInfo : this.myModuleLibraries) {
            String moduleLibraryPath = (String)libInfo.first;
            String sourceLibraryPath = (String)libInfo.second;
            Library library = libraryTable.createLibrary();
            Library.ModifiableModel modifiableModel = library.getModifiableModel();
            modifiableModel.addRoot(JavaModuleBuilder.getUrlByPath(moduleLibraryPath), OrderRootType.CLASSES);
            if (sourceLibraryPath != null) {
                modifiableModel.addRoot(JavaModuleBuilder.getUrlByPath(sourceLibraryPath), OrderRootType.SOURCES);
            }
            modifiableModel.commit();
        }
    }

    private static String getUrlByPath(String path) {
        return VfsUtil.getUrlForLibraryRoot(new File(path));
    }

    public void addModuleLibrary(String moduleLibraryPath, String sourcePath) {
        this.myModuleLibraries.add((Pair<String, String>)Pair.create((Object)moduleLibraryPath, (Object)sourcePath));
    }

    public void setModuleJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    public Sdk getModuleJdk() {
        return this.myJdk;
    }

    @Nullable
    protected static String getPathForOutputPathStep() {
        return null;
    }

    @Override
    public boolean isSuitableSdk(Sdk sdk) {
        return sdk.getSdkType() == JavaSdk.getInstance();
    }
}

