/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginBean;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginHelpSet;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.xmlb.JDOMXIncluder;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginDescriptor");
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    private String myName;
    private PluginId myId;
    private String myDescription;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myVendorLogoPath;
    private String myCategory;
    private String url;
    private File myPath;
    private PluginId[] myDependencies = PluginId.EMPTY_ARRAY;
    private PluginId[] myOptionalDependencies = PluginId.EMPTY_ARRAY;
    private Map<PluginId, String> myOptionalConfigs;
    private Map<PluginId, IdeaPluginDescriptorImpl> myOptionalDescriptors;
    @Nullable
    private List<Element> myActionsElements;
    private ComponentConfig[] myAppComponents = null;
    private ComponentConfig[] myProjectComponents = null;
    private ComponentConfig[] myModuleComponents = null;
    private boolean myDeleted = false;
    private ClassLoader myLoader;
    private HelpSetPath[] myHelpSets;
    @Nullable
    private List<Element> myExtensions;
    @Nullable
    private List<Element> myExtensionsPoints;
    private String myDescriptionChildText;
    private String myDownloadCounter;
    private long myDate;
    private boolean myUseIdeaClassLoader;
    private boolean myUseCoreClassLoader;
    private boolean myEnabled = true;
    private String mySinceBuild;
    private String myUntilBuild;
    private Boolean mySkipped;
    private List<String> myModules = null;
    protected static StringInterner ourInterner = new StringInterner();

    public IdeaPluginDescriptorImpl(File pluginPath) {
        this.myPath = pluginPath;
    }

    public void setPath(File path) {
        this.myPath = path;
    }

    @Override
    public File getPath() {
        return this.myPath;
    }

    public void readExternal(URL url) throws InvalidDataException, FileNotFoundException {
        try {
            Document document = JDOMUtil.loadDocument((URL)url);
            document = JDOMXIncluder.resolve((Document)document, (String)url.toExternalForm());
            JDOMUtil.internElement((Element)document.getRootElement(), (StringInterner)ourInterner);
            this.readExternal(document.getRootElement());
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw new InvalidDataException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new InvalidDataException((Throwable)e);
        }
    }

    private void readExternal(Element element) {
        PluginBean pluginBean = (PluginBean)XmlSerializer.deserialize((Element)element, PluginBean.class);
        this.url = pluginBean.url;
        this.myName = pluginBean.name;
        String idString = pluginBean.id;
        if (idString == null || idString.length() == 0) {
            idString = this.myName;
        }
        this.myId = PluginId.getId((String)idString);
        String internalVersionString = pluginBean.formatVersion;
        if (internalVersionString != null) {
            try {
                int formatVersion = Integer.parseInt(internalVersionString);
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)new PluginException("Invalid value in plugin.xml format version: " + internalVersionString, e, this.myId));
            }
        }
        this.myUseIdeaClassLoader = pluginBean.useIdeaClassLoader;
        if (pluginBean.ideaVersion != null) {
            this.mySinceBuild = pluginBean.ideaVersion.sinceBuild;
            this.myUntilBuild = pluginBean.ideaVersion.untilBuild;
        }
        this.myResourceBundleBaseName = pluginBean.resourceBundle;
        this.myDescriptionChildText = pluginBean.description;
        this.myChangeNotes = pluginBean.changeNotes;
        this.myVersion = pluginBean.pluginVersion;
        this.myCategory = pluginBean.category;
        if (pluginBean.vendor != null) {
            this.myVendor = pluginBean.vendor.name;
            this.myVendorEmail = pluginBean.vendor.email;
            this.myVendorUrl = pluginBean.vendor.url;
            this.myVendorLogoPath = pluginBean.vendor.logo;
        }
        HashSet<PluginId> dependentPlugins = new HashSet<PluginId>();
        HashSet<PluginId> optionalDependentPlugins = new HashSet<PluginId>();
        this.myOptionalConfigs = new HashMap<PluginId, String>();
        if (pluginBean.dependencies != null) {
            for (PluginDependency dependency : pluginBean.dependencies) {
                String text = dependency.pluginId;
                if (text == null || text.length() <= 0) continue;
                PluginId id = PluginId.getId((String)text);
                dependentPlugins.add(id);
                if (!dependency.optional) continue;
                optionalDependentPlugins.add(id);
                if (dependency.configFile == null || dependency.configFile.length() <= 0) continue;
                this.myOptionalConfigs.put(id, dependency.configFile);
            }
        }
        this.myDependencies = dependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : dependentPlugins.toArray(new PluginId[dependentPlugins.size()]);
        this.myOptionalDependencies = optionalDependentPlugins.isEmpty() ? PluginId.EMPTY_ARRAY : optionalDependentPlugins.toArray(new PluginId[optionalDependentPlugins.size()]);
        ArrayList<HelpSetPath> hsPathes = new ArrayList<HelpSetPath>();
        if (pluginBean.helpSets != null) {
            for (PluginHelpSet pluginHelpSet : pluginBean.helpSets) {
                HelpSetPath hsPath = new HelpSetPath(pluginHelpSet.file, pluginHelpSet.path);
                hsPathes.add(hsPath);
            }
        }
        this.myHelpSets = hsPathes.size() > 0 ? hsPathes.toArray(new HelpSetPath[hsPathes.size()]) : HelpSetPath.EMPTY;
        this.myAppComponents = pluginBean.applicationComponents;
        this.myProjectComponents = pluginBean.projectComponents;
        this.myModuleComponents = pluginBean.moduleComponents;
        if (this.myAppComponents == null) {
            this.myAppComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myProjectComponents == null) {
            this.myProjectComponents = ComponentConfig.EMPTY_ARRAY;
        }
        if (this.myModuleComponents == null) {
            this.myModuleComponents = ComponentConfig.EMPTY_ARRAY;
        }
        this.myExtensions = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensions);
        this.myExtensionsPoints = IdeaPluginDescriptorImpl.copyElements(pluginBean.extensionPoints);
        this.myActionsElements = IdeaPluginDescriptorImpl.copyElements(pluginBean.actions);
        if (pluginBean.extensionPoints != null) {
            this.myExtensionsPoints = new ArrayList<Element>();
            for (Element root : pluginBean.extensionPoints) {
                for (Object o : root.getChildren()) {
                    this.myExtensionsPoints.add((Element)o);
                }
            }
        }
        if (pluginBean.modules != null && !pluginBean.modules.isEmpty()) {
            this.myModules = pluginBean.modules;
        }
    }

    @Nullable
    private static List<Element> copyElements(Element[] elements) {
        if (elements != null) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element extensionsRoot : elements) {
                for (Object o : extensionsRoot.getChildren()) {
                    result.add((Element)o);
                }
            }
            return result;
        }
        return null;
    }

    private static String loadDescription(String descriptionChildText, @Nullable ResourceBundle bundle, PluginId id) {
        if (bundle == null) {
            return descriptionChildText;
        }
        return CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)IdeaPluginDescriptorImpl.createDescriptionKey(id), (String)(descriptionChildText == null ? "" : descriptionChildText), (Object[])new Object[0]);
    }

    private static String createDescriptionKey(PluginId id) {
        return "plugin." + id + ".description";
    }

    void registerExtensions() {
        if (this.myExtensions != null || this.myExtensionsPoints != null) {
            Extensions.getRootArea().getExtensionPoint(Extensions.AREA_LISTENER_EXTENSION_POINT).registerExtension((Object)new AreaListener(){

                public void areaCreated(String areaClass, AreaInstance areaInstance) {
                    if (PluginManager.shouldSkipPlugin(IdeaPluginDescriptorImpl.this)) {
                        return;
                    }
                    ExtensionsArea area = Extensions.getArea((AreaInstance)areaInstance);
                    area.registerAreaExtensionsAndPoints((PluginDescriptor)IdeaPluginDescriptorImpl.this, IdeaPluginDescriptorImpl.this.myExtensionsPoints, IdeaPluginDescriptorImpl.this.myExtensions);
                }

                public void areaDisposing(String areaClass, AreaInstance areaInstance) {
                }
            });
        }
    }

    @Override
    public String getDescription() {
        return this.myDescription == null ? this.myDescriptionChildText : this.myDescription;
    }

    @Override
    public String getChangeNotes() {
        return this.myChangeNotes;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (this.myDependencies == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/IdeaPluginDescriptorImpl.getDependentPluginIds must not return null");
        }
        return this.myDependencies;
    }

    @Override
    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        if (this.myOptionalDependencies == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/IdeaPluginDescriptorImpl.getOptionalDependentPluginIds must not return null");
        }
        return this.myOptionalDependencies;
    }

    @Override
    public String getVendor() {
        return this.myVendor;
    }

    @Override
    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public String getResourceBundleBaseName() {
        return this.myResourceBundleBaseName;
    }

    @Override
    public String getCategory() {
        return this.myCategory;
    }

    public List<File> getClassPath() {
        if (this.myPath.isDirectory()) {
            File[] files;
            ArrayList<File> result = new ArrayList<File>();
            File classesDir = new File(this.myPath, "classes");
            if (classesDir.exists()) {
                result.add(classesDir);
            }
            if ((files = new File(this.myPath, "lib").listFiles()) != null && files.length > 0) {
                for (File f : files) {
                    if (f.isFile()) {
                        String name = f.getName();
                        if (!StringUtil.endsWithIgnoreCase((String)name, (String)".jar") && !StringUtil.endsWithIgnoreCase((String)name, (String)".zip")) continue;
                        result.add(f);
                        continue;
                    }
                    result.add(f);
                }
            }
            return result;
        }
        return Collections.singletonList(this.myPath);
    }

    @Override
    @Nullable
    public List<Element> getActionsDescriptionElements() {
        return this.myActionsElements;
    }

    @Override
    @NotNull
    public ComponentConfig[] getAppComponents() {
        if (this.myAppComponents == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/IdeaPluginDescriptorImpl.getAppComponents must not return null");
        }
        return this.myAppComponents;
    }

    @Override
    @NotNull
    public ComponentConfig[] getProjectComponents() {
        if (this.myProjectComponents == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/IdeaPluginDescriptorImpl.getProjectComponents must not return null");
        }
        return this.myProjectComponents;
    }

    @Override
    @NotNull
    public ComponentConfig[] getModuleComponents() {
        if (this.myModuleComponents == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/IdeaPluginDescriptorImpl.getModuleComponents must not return null");
        }
        return this.myModuleComponents;
    }

    @Override
    public String getVendorEmail() {
        return this.myVendorEmail;
    }

    @Override
    public String getVendorUrl() {
        return this.myVendorUrl;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @NonNls
    public String toString() {
        return "PluginDescriptor[name='" + this.myName + "', classpath='" + this.myPath + "']";
    }

    public boolean isDeleted() {
        return this.myDeleted;
    }

    public void setDeleted(boolean deleted) {
        this.myDeleted = deleted;
    }

    public void setLoader(ClassLoader loader, boolean registerExtensions) {
        this.myLoader = loader;
        if (registerExtensions) {
            Extensions.getRootArea().registerAreaExtensionsAndPoints((PluginDescriptor)this, this.myExtensionsPoints, this.myExtensions);
        }
        this.initialize(this.getPluginClassLoader());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeaPluginDescriptorImpl)) {
            return false;
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)o;
        return !(this.myName != null ? !this.myName.equals(pluginDescriptor.myName) : pluginDescriptor.myName != null);
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    @Override
    @NotNull
    public HelpSetPath[] getHelpSets() {
        if (this.myHelpSets == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/IdeaPluginDescriptorImpl.getHelpSets must not return null");
        }
        return this.myHelpSets;
    }

    public PluginId getPluginId() {
        return this.myId;
    }

    public void setCategory(String category) {
        this.myCategory = category;
    }

    public void setDownloadsCount(String dwnlds) {
        this.myDownloadCounter = dwnlds;
    }

    @Override
    public String getDownloads() {
        return this.myDownloadCounter;
    }

    public void setDate(long date) {
        this.myDate = date;
    }

    public long getDate() {
        return this.myDate;
    }

    public void setVendor(String val) {
        this.myVendor = val;
    }

    public void setVendorEmail(String val) {
        this.myVendorEmail = val;
    }

    public void setVendorUrl(String val) {
        this.myVendorUrl = val;
    }

    public void setUrl(String val) {
        this.url = val;
    }

    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    @Override
    public String getVendorLogoPath() {
        return this.myVendorLogoPath;
    }

    @Override
    public boolean getUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    public boolean isUseCoreClassLoader() {
        return this.myUseCoreClassLoader;
    }

    public void setUseCoreClassLoader(boolean useCoreClassLoader) {
        this.myUseCoreClassLoader = useCoreClassLoader;
    }

    public void setVendorLogoPath(String vendorLogoPath) {
        this.myVendorLogoPath = vendorLogoPath;
    }

    public void initialize(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/plugins/IdeaPluginDescriptorImpl.initialize must not be null");
        }
        ResourceBundle bundle = null;
        if (this.myResourceBundleBaseName != null) {
            try {
                bundle = ResourceBundle.getBundle(this.myResourceBundleBaseName, Locale.getDefault(), classLoader);
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot find plugin " + this.myId + " resource-bundle: " + this.myResourceBundleBaseName);
            }
        }
        this.myDescription = IdeaPluginDescriptorImpl.loadDescription(this.myDescriptionChildText, bundle, this.myId);
    }

    public void insertDependency(IdeaPluginDescriptor d) {
        PluginId[] deps = new PluginId[this.getDependentPluginIds().length + 1];
        deps[0] = d.getPluginId();
        System.arraycopy(this.myDependencies, 0, deps, 1, deps.length - 1);
        this.myDependencies = deps;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Override
    public String getSinceBuild() {
        return this.mySinceBuild;
    }

    @Override
    public String getUntilBuild() {
        return this.myUntilBuild;
    }

    Map<PluginId, String> getOptionalConfigs() {
        return this.myOptionalConfigs;
    }

    Map<PluginId, IdeaPluginDescriptorImpl> getOptionalDescriptors() {
        return this.myOptionalDescriptors;
    }

    void setOptionalDescriptors(Map<PluginId, IdeaPluginDescriptorImpl> optionalDescriptors) {
        this.myOptionalDescriptors = optionalDescriptors;
    }

    void mergeOptionalConfig(IdeaPluginDescriptorImpl descriptor) {
        if (this.myExtensions == null) {
            this.myExtensions = descriptor.myExtensions;
        } else if (descriptor.myExtensions != null) {
            this.myExtensions.addAll(descriptor.myExtensions);
        }
        if (this.myActionsElements == null) {
            this.myActionsElements = descriptor.myActionsElements;
        } else if (descriptor.myActionsElements != null) {
            this.myActionsElements.addAll(descriptor.myActionsElements);
        }
        this.myAppComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myAppComponents, descriptor.myAppComponents);
        this.myProjectComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myProjectComponents, descriptor.myProjectComponents);
        this.myModuleComponents = IdeaPluginDescriptorImpl.mergeComponents(this.myModuleComponents, descriptor.myModuleComponents);
    }

    private static ComponentConfig[] mergeComponents(ComponentConfig[] first, ComponentConfig[] second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return (ComponentConfig[])ArrayUtil.mergeArrays((Object[])first, (Object[])second, ComponentConfig.class);
    }

    public Boolean getSkipped() {
        return this.mySkipped;
    }

    public void setSkipped(Boolean skipped) {
        this.mySkipped = skipped;
    }

    @Override
    public boolean isBundled() {
        return this.getPath().getAbsolutePath().startsWith(PathManager.getPreinstalledPluginsPath());
    }

    @Nullable
    public List<String> getModules() {
        return this.myModules;
    }
}

