/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryDownloadInfo {
    private final RemoteRepositoryInfo myRemoteRepository;
    private final String myRelativeDownloadUrl;
    private final String myFileNamePrefix;
    private final String myFileNameSuffix;
    @Nullable
    private final String myPresentableUrl;

    public LibraryDownloadInfo(@NotNull RemoteRepositoryInfo remoteRepository, @NotNull @NonNls String relativeDownloadUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (remoteRepository == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (relativeDownloadUrl == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this.myRemoteRepository = remoteRepository;
        this.myRelativeDownloadUrl = relativeDownloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = null;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix, @NotNull @NonNls String fileNameSuffix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNameSuffix == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this.myRemoteRepository = null;
        this.myRelativeDownloadUrl = downloadUrl;
        this.myFileNamePrefix = fileNamePrefix;
        this.myFileNameSuffix = fileNameSuffix;
        this.myPresentableUrl = presentableUrl != null ? presentableUrl : downloadUrl;
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @Nullable String presentableUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this(downloadUrl, presentableUrl, fileNamePrefix, ".jar");
    }

    public LibraryDownloadInfo(@NotNull String downloadUrl, @NotNull @NonNls String fileNamePrefix) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        if (fileNamePrefix == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/ui/libraries/LibraryDownloadInfo.<init> must not be null");
        }
        this(downloadUrl, null, fileNamePrefix);
    }

    @NotNull
    public String getDownloadUrl() {
        String string = this.myRemoteRepository != null ? this.getDownloadUrl(this.myRemoteRepository.getDefaultMirror()) : this.myRelativeDownloadUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getDownloadUrl must not return null");
        }
        return string;
    }

    @NotNull
    public String getDownloadUrl(String mirror) {
        String string = mirror + this.myRelativeDownloadUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getDownloadUrl must not return null");
        }
        return string;
    }

    @Nullable
    public RemoteRepositoryInfo getRemoteRepository() {
        return this.myRemoteRepository;
    }

    @NotNull
    public String getFileNamePrefix() {
        String string = this.myFileNamePrefix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getFileNamePrefix must not return null");
        }
        return string;
    }

    @NotNull
    public String getFileNameSuffix() {
        String string = this.myFileNameSuffix;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getFileNameSuffix must not return null");
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : (this.myRemoteRepository != null ? this.myRemoteRepository.getDefaultMirror() : this.myRelativeDownloadUrl);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getPresentableUrl must not return null");
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl(String mirror) {
        String string = this.myPresentableUrl != null ? this.myPresentableUrl : mirror;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/ui/libraries/LibraryDownloadInfo.getPresentableUrl must not return null");
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryDownloadInfo that = (LibraryDownloadInfo)o;
        if (!this.myFileNamePrefix.equals(that.myFileNamePrefix)) {
            return false;
        }
        if (!this.myFileNameSuffix.equals(that.myFileNameSuffix)) {
            return false;
        }
        if (!Comparing.equal((String)this.myPresentableUrl, (String)that.myPresentableUrl)) {
            return false;
        }
        if (!this.myRelativeDownloadUrl.equals(that.myRelativeDownloadUrl)) {
            return false;
        }
        return Comparing.equal((Object)this.myRemoteRepository, (Object)that.myRemoteRepository);
    }

    public int hashCode() {
        int result = this.myRemoteRepository.hashCode();
        result = 31 * result + this.myRelativeDownloadUrl.hashCode();
        result = 31 * result + this.myFileNamePrefix.hashCode();
        result = 31 * result + this.myFileNameSuffix.hashCode();
        if (this.myPresentableUrl != null) {
            result = 31 * result + this.myPresentableUrl.hashCode();
        }
        return result;
    }
}

