/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;

public class ProgramRunnerUtil {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.execution.runners.ProgramRunnerUtil");

    private ProgramRunnerUtil() {
    }

    public static void handleExecutionError(Project project, RunProfile runProfile, ExecutionException e) {
        ProgramRunnerUtil.handleExecutionError(project, runProfile != null ? runProfile.getName() : "Run profile", e);
    }

    public static void handleExecutionError(Project project, String runProfileName, ExecutionException e) {
        if (e instanceof RunCanceledByUserException) {
            return;
        }
        String message = ExecutionBundle.message("error.running.configuration.with.error.error.message", runProfileName, e.getMessage());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(message);
        } else {
            String commandLineString;
            if (message.contains("87") && e instanceof ProcessNotCreatedException && (commandLineString = ((ProcessNotCreatedException)e).getCommandLine().getCommandLineString()).length() > 32768 && Messages.showYesNoDialog(project, message + "\nCommand line is too long. In order to reduce its length classpath file can be used. Would you like to enable classpath file mode for all run configurations of your project?", ExecutionBundle.message("run.error.message.title", new Object[0]), Messages.getErrorIcon()) == 0) {
                PropertiesComponent.getInstance(project).setValue("dynamic.classpath", "true");
                return;
            }
            Messages.showErrorDialog(project, message, ExecutionBundle.message("run.error.message.title", new Object[0]));
        }
    }
}

