/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NonNls;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    private static final String BEFORE_PREFIX = "before";
    private static QuickFixTestCase myWrapper;

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    protected Pair<String, Boolean> parseActionHintImpl(PsiFile file, String contents) {
        return LightQuickFixTestCase.parseActionHint(file, contents);
    }

    private static void doTestFor(final String testName, final QuickFixTestCase quickFixTestCase) {
        CommandProcessor.getInstance().executeCommand(LightQuickFixTestCase.getProject(), new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String relativePath = quickFixTestCase.getBasePath() + "/" + LightQuickFixTestCase.BEFORE_PREFIX + testName;
                        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
                        File ioFile = new File(testFullPath);
                        try {
                            String contents = StringUtil.convertLineSeparators((String)new String(FileUtil.loadFileText((File)ioFile, (String)"UTF-8")));
                            quickFixTestCase.configureFromFileText(ioFile.getName(), contents);
                            quickFixTestCase.bringRealEditorBack();
                            Pair<String, Boolean> pair = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                            String text = (String)pair.getFirst();
                            boolean actionShouldBeAvailable = (Boolean)pair.getSecond();
                            quickFixTestCase.beforeActionStarted(testName, contents);
                            try {
                                myWrapper = quickFixTestCase;
                                quickFixTestCase.doAction(text, actionShouldBeAvailable, testFullPath, testName);
                            }
                            finally {
                                myWrapper = null;
                                quickFixTestCase.afterActionCompleted(testName, contents);
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            Assert.fail();
                        }
                    }
                });
            }
        }, "", "");
        System.out.print(testName + " ");
    }

    protected void afterActionCompleted(String testName, String contents) {
    }

    protected void beforeActionStarted(String testName, String contents) {
    }

    public static Pair<String, Boolean> parseActionHint(PsiFile file, String contents) {
        return LightQuickFixTestCase.parseActionHint(file, contents, " \"(.*)\" \"(true|false)\".*");
    }

    public static Pair<String, Boolean> parseActionHint(PsiFile file, String contents, @NonNls @RegExp String actionPattern) {
        PsiFile hostFile = InjectedLanguageUtil.getTopLevelFile((PsiElement)file);
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(hostFile.getLanguage());
        String comment = commenter.getLineCommentPrefix();
        if (comment == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        Pattern pattern = Pattern.compile("^" + comment.replace("*", "\\*") + actionPattern, 32);
        Matcher matcher = pattern.matcher(contents);
        LightQuickFixTestCase.assertTrue((String)("No comment found in " + file.getVirtualFile()), (boolean)matcher.matches());
        String text = matcher.group(1);
        Boolean actionShouldBeAvailable = Boolean.valueOf(matcher.group(2));
        return Pair.create((Object)text, (Object)actionShouldBeAvailable);
    }

    public static void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName, QuickFixTestCase quickFixTestCase) throws Exception {
        IntentionAction action = quickFixTestCase.findActionWithText(text);
        if (action == null) {
            if (actionShouldBeAvailable) {
                List<IntentionAction> actions = quickFixTestCase.getAvailableActions();
                ArrayList<String> texts = new ArrayList<String>();
                for (IntentionAction intentionAction : actions) {
                    texts.add(intentionAction.getText());
                }
                List<HighlightInfo> infos = quickFixTestCase.doHighlighting();
                LightQuickFixTestCase.fail((String)("Action with text '" + text + "' is not available in test " + testFullPath + "\nAvailable actions: " + texts + "\n" + actions + "\nErrors:" + infos));
            }
        } else {
            IntentionAction afterAction;
            if (!actionShouldBeAvailable) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is available in test " + testFullPath));
            }
            quickFixTestCase.invoke(action);
            if (!quickFixTestCase.shouldBeAvailableAfterExecution() && (afterAction = quickFixTestCase.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = quickFixTestCase.getBasePath() + "/after" + testName;
            quickFixTestCase.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
        }
    }

    protected void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName) throws Exception {
        LightQuickFixTestCase.doAction(text, actionShouldBeAvailable, testFullPath, testName, myWrapper);
    }

    protected static void invoke(IntentionAction action) throws IncorrectOperationException {
        ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)LightQuickFixTestCase.getFile(), (Editor)LightQuickFixTestCase.getEditor(), (IntentionAction)action, (String)action.getText());
    }

    protected IntentionAction findActionWithText(String text) {
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(List<IntentionAction> actions, String text) {
        for (IntentionAction action : actions) {
            if (!text.equals(action.getText())) continue;
            return action;
        }
        return null;
    }

    public static void doAllTests(QuickFixTestCase testCase) throws Exception {
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase.getBasePath());
        String testDirPath = testCase.getTestDataPath().replace(File.separatorChar, '/') + testCase.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, @NonNls String name) {
                return name.startsWith(LightQuickFixTestCase.BEFORE_PREFIX);
            }
        });
        if (files == null) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        for (File file : files) {
            String testName = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName, testCase);
        }
        LightQuickFixTestCase.assertTrue((String)("Test files not found in " + testDirPath), (files.length != 0 ? 1 : 0) != 0);
    }

    protected void doAllTests() throws Exception {
        LightQuickFixTestCase.doAllTests(new QuickFixTestCase(){

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            public String getTestDataPath() {
                return LightQuickFixTestCase.this.getTestDataPath();
            }

            @Override
            public Pair<String, Boolean> parseActionHintImpl(PsiFile file, String contents) {
                return LightQuickFixTestCase.this.parseActionHintImpl(file, contents);
            }

            @Override
            public void beforeActionStarted(String testName, String contents) {
                LightQuickFixTestCase.this.beforeActionStarted(testName, contents);
            }

            @Override
            public void afterActionCompleted(String testName, String contents) {
                LightQuickFixTestCase.this.afterActionCompleted(testName, contents);
            }

            @Override
            public void doAction(String text, boolean actionShouldBeAvailable, String testFullPath, String testName) throws Exception {
                LightQuickFixTestCase.this.doAction(text, actionShouldBeAvailable, testFullPath, testName);
            }

            @Override
            public void checkResultByFile(String s, String expectedFilePath, boolean b) throws Exception {
                LightQuickFixTestCase.this.checkResultByFile(s, expectedFilePath, b);
            }

            @Override
            public IntentionAction findActionWithText(String text) {
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(IntentionAction action) {
                LightQuickFixTestCase.invoke(action);
            }

            @Override
            public List<HighlightInfo> doHighlighting() {
                return LightQuickFixTestCase.this.doHighlighting();
            }

            @Override
            public List<IntentionAction> getAvailableActions() {
                return LightQuickFixTestCase.this.getAvailableActions();
            }

            @Override
            public void configureFromFileText(String name, String contents) throws IOException {
                LightQuickFixTestCase.configureFromFileText((String)name, (String)contents);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.getFile();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.bringRealEditorBack();
            }
        });
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(LightQuickFixTestCase.getEditor(), LightQuickFixTestCase.getFile());
    }

    public static List<IntentionAction> getAvailableActions(Editor editor, PsiFile file) {
        return CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)editor, (PsiFile)file);
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }
}

