/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Set;

public class OffsetMap {
    private final Document myDocument;
    private final Map<OffsetKey, RangeMarker> myMap = new THashMap();

    public OffsetMap(Document document) {
        this.myDocument = document;
    }

    public int getOffset(OffsetKey key) {
        RangeMarker marker = this.myMap.get(key);
        if (marker == null) {
            return -1;
        }
        if (!marker.isValid()) {
            this.removeOffset(key);
            return -1;
        }
        int endOffset = marker.getEndOffset();
        if (marker.getStartOffset() != endOffset) {
            this.addOffset(key, endOffset);
        }
        return endOffset;
    }

    public void addOffset(OffsetKey key, int offset) {
        if (offset < 0) {
            this.removeOffset(key);
            return;
        }
        RangeMarker marker = this.myDocument.createRangeMarker(offset, offset);
        marker.setGreedyToRight(key.isMoveableToRight());
        this.myMap.put(key, marker);
    }

    public void removeOffset(OffsetKey key) {
        this.myMap.remove(key);
    }

    public Set<OffsetKey> keySet() {
        return this.myMap.keySet();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OffsetMap:");
        for (OffsetKey key : this.myMap.keySet()) {
            builder.append(key).append("->").append(this.myMap.get(key)).append(";");
        }
        return builder.toString();
    }
}

