/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AbstractCompletionContributor;
import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompletionContributor
extends AbstractCompletionContributor<CompletionParameters> {
    private final MultiMap<CompletionType, Pair<ElementPattern<? extends PsiElement>, CompletionProvider<CompletionParameters>>> myMap = new MultiMap();

    public final void extend(@Nullable CompletionType type, ElementPattern<? extends PsiElement> place, CompletionProvider<CompletionParameters> provider) {
        this.myMap.putValue((Object)type, (Object)new Pair(place, provider));
    }

    @Override
    public void fillCompletionVariants(CompletionParameters parameters, CompletionResultSet result) {
        ProcessingContext context;
        for (Pair pair : this.myMap.get((Object)parameters.getCompletionType())) {
            context = new ProcessingContext();
            if (!CompletionContributor.isPatternSuitable((ElementPattern)pair.first, parameters, context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result);
            if (!result.isStopped()) continue;
            return;
        }
        for (Pair pair : this.myMap.get(null)) {
            context = new ProcessingContext();
            if (!CompletionContributor.isPatternSuitable((ElementPattern)pair.first, parameters, context)) continue;
            ((CompletionProvider)pair.second).addCompletionVariants(parameters, context, result);
            if (!result.isStopped()) continue;
            return;
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionContributor.beforeCompletion must not be null");
        }
    }

    @Nullable
    public String advertise(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionContributor.advertise must not be null");
        }
        return null;
    }

    @Nullable
    public String handleEmptyLookup(@NotNull CompletionParameters parameters, Editor editor) {
        if (parameters == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionContributor.handleEmptyLookup must not be null");
        }
        return null;
    }

    @Nullable
    public AutoCompletionDecision handleAutoCompletionPossibility(AutoCompletionContext context) {
        return null;
    }

    protected static String getActionShortcut(@NonNls String actionId) {
        return KeymapUtil.getFirstKeyboardShortcutText(ActionManager.getInstance().getAction(actionId));
    }

    public static List<CompletionContributor> forParameters(final CompletionParameters parameters) {
        return ApplicationManager.getApplication().runReadAction(new Computable<List<CompletionContributor>>(){

            public List<CompletionContributor> compute() {
                return CompletionContributor.forLanguage(PsiUtilBase.getLanguageAtOffset(parameters.getPosition().getContainingFile(), parameters.getOffset()));
            }
        });
    }

    public static List<CompletionContributor> forLanguage(Language language) {
        return MyExtensionPointManager.INSTANCE.forKey(language);
    }

    private static class MyExtensionPointManager
    extends KeyedExtensionCollector<CompletionContributor, Language> {
        public static final MyExtensionPointManager INSTANCE = new MyExtensionPointManager();

        MyExtensionPointManager() {
            super("com.intellij.completion.contributor");
        }

        @Override
        protected List<CompletionContributor> buildExtensions(String stringKey, Language key) {
            THashSet allowed = new THashSet();
            while (key != null) {
                allowed.add((Object)this.keyToString(key));
                key = key.getBaseLanguage();
            }
            allowed.add((Object)"any");
            return this.buildExtensions((Set<String>)allowed);
        }

        @Override
        protected String keyToString(Language key) {
            return key.getID();
        }
    }
}

