/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.OptionGroup;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class IndentOptionsEditor
extends OptionGroup {
    private JTextField myIndentField;
    protected JCheckBox myCbUseTab;
    private JTextField myTabSizeField;
    private JLabel myTabSizeLabel;
    private JLabel myIndentLabel;

    @Override
    public JPanel createPanel() {
        this.addComponents();
        JPanel result = super.createPanel();
        result.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        return result;
    }

    protected void addComponents() {
        this.addTabOptions();
        this.myTabSizeField = new JTextField(4);
        this.myTabSizeField.setMinimumSize(this.myTabSizeField.getPreferredSize());
        this.myTabSizeLabel = new JLabel(ApplicationBundle.message("editbox.indent.tab.size", new Object[0]));
        this.add((JComponent)this.myTabSizeLabel, this.myTabSizeField);
        this.myIndentField = new JTextField(4);
        this.myIndentField.setMinimumSize(this.myTabSizeField.getPreferredSize());
        this.myIndentLabel = new JLabel(ApplicationBundle.message("editbox.indent.indent", new Object[0]));
        this.add((JComponent)this.myIndentLabel, this.myIndentField);
    }

    protected void addTabOptions() {
        this.myCbUseTab = new JCheckBox(ApplicationBundle.message("checkbox.indent.use.tab.character", new Object[0]));
        this.add(this.myCbUseTab);
    }

    protected static boolean isFieldModified(JCheckBox checkBox, boolean value) {
        return checkBox.isSelected() != value;
    }

    protected static boolean isFieldModified(JTextField textField, int value) {
        try {
            int fieldValue = Integer.parseInt(textField.getText().trim());
            return fieldValue != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isModified(CodeStyleSettings settings, CodeStyleSettings.IndentOptions options) {
        boolean isModified = IndentOptionsEditor.isFieldModified(this.myTabSizeField, options.TAB_SIZE);
        isModified |= IndentOptionsEditor.isFieldModified(this.myCbUseTab, options.USE_TAB_CHARACTER);
        return isModified |= IndentOptionsEditor.isFieldModified(this.myIndentField, options.INDENT_SIZE);
    }

    protected int getUIIndent() {
        String indentText = this.myIndentField.getText();
        try {
            return Math.max(Integer.parseInt(indentText), 1);
        }
        catch (NumberFormatException numberFormatException) {
            return 4;
        }
    }

    protected int getUITabSize() {
        try {
            return Math.max(Integer.parseInt(this.myTabSizeField.getText()), 1);
        }
        catch (NumberFormatException numberFormatException) {
            return 4;
        }
    }

    public void apply(CodeStyleSettings settings, CodeStyleSettings.IndentOptions options) {
        options.INDENT_SIZE = this.getUIIndent();
        options.TAB_SIZE = this.getUITabSize();
        options.USE_TAB_CHARACTER = this.myCbUseTab.isSelected();
    }

    public void reset(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/IndentOptionsEditor.reset must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/application/options/IndentOptionsEditor.reset must not be null");
        }
        this.myTabSizeField.setText(String.valueOf(options.TAB_SIZE));
        this.myCbUseTab.setSelected(options.USE_TAB_CHARACTER);
        this.myIndentField.setText(String.valueOf(options.INDENT_SIZE));
    }

    public void setEnabled(boolean enabled) {
        this.myIndentField.setEnabled(enabled);
        this.myIndentLabel.setEnabled(enabled);
        this.myTabSizeField.setEnabled(enabled);
        this.myTabSizeLabel.setEnabled(enabled);
        this.myCbUseTab.setEnabled(enabled);
    }
}

