/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.Navigatable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.snapShooter.SnapShooter;
import com.intellij.uiDesigner.snapShooter.SnapShooterConfigurationSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.net.NetUtils;
import com.intellij.xml.util.XmlStringUtil;
import com.jgoodies.forms.layout.FormLayout;
import gnu.trove.THashMap;
import java.io.IOException;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;

public class SnapShooterConfigurationExtension
extends RunConfigurationExtension {
    public <T extends ModuleBasedConfiguration> void updateJavaParameters(T configuration, JavaParameters params, RunnerSettings runnerSettings) {
        if (!(configuration instanceof ApplicationConfiguration)) {
            return;
        }
        ApplicationConfiguration appConfiguration = (ApplicationConfiguration)configuration;
        SnapShooterConfigurationSettings settings = (SnapShooterConfigurationSettings)appConfiguration.getUserData(SnapShooterConfigurationSettings.SNAP_SHOOTER_KEY);
        if (settings == null) {
            settings = new SnapShooterConfigurationSettings();
            appConfiguration.putUserData(SnapShooterConfigurationSettings.SNAP_SHOOTER_KEY, (Object)settings);
        }
        if (appConfiguration.ENABLE_SWING_INSPECTOR) {
            try {
                settings.setLastPort(NetUtils.findAvailableSocketPort());
            }
            catch (IOException ex) {
                settings.setLastPort(-1);
            }
        }
        if (appConfiguration.ENABLE_SWING_INSPECTOR && settings.getLastPort() != -1) {
            params.getProgramParametersList().prepend(appConfiguration.MAIN_CLASS_NAME);
            params.getProgramParametersList().prepend(Integer.toString(settings.getLastPort()));
            params.getProgramParametersList().prepend(Integer.toString(params.getClassPath().getPathList().size() + 1));
            TreeSet<String> paths = new TreeSet<String>();
            paths.add(PathUtil.getJarPathForClass(SnapShooter.class));
            paths.add(PathUtil.getJarPathForClass(BaseComponent.class));
            paths.add(PathUtil.getJarPathForClass(ProjectComponent.class));
            paths.add(PathUtil.getJarPathForClass(LwComponent.class));
            paths.add(PathUtil.getJarPathForClass(GridConstraints.class));
            paths.add(PathUtil.getJarPathForClass(JDOMExternalizable.class));
            paths.add(PathUtil.getJarPathForClass(Document.class));
            paths.add(PathUtil.getJarPathForClass(LafManagerListener.class));
            paths.add(PathUtil.getJarPathForClass(DataProvider.class));
            paths.add(PathUtil.getJarPathForClass(XmlStringUtil.class));
            paths.add(PathUtil.getJarPathForClass(Navigatable.class));
            paths.add(PathUtil.getJarPathForClass(AreaInstance.class));
            paths.add(PathUtil.getJarPathForClass(THashMap.class));
            paths.add(PathUtil.getJarPathForClass(FormLayout.class));
            for (String path : paths) {
                params.getClassPath().addFirst(path);
            }
            params.setMainClass("com.intellij.uiDesigner.snapShooter.SnapShooter");
        }
    }

    public void handleStartProcess(ModuleBasedConfiguration configuration, OSProcessHandler handler) {
        Runnable runnable;
        SnapShooterConfigurationSettings settings = (SnapShooterConfigurationSettings)configuration.getUserData(SnapShooterConfigurationSettings.SNAP_SHOOTER_KEY);
        if (settings != null && (runnable = settings.getNotifyRunnable()) != null) {
            settings.setNotifyRunnable(null);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    runnable.run();
                }
            });
        }
    }

    public <T extends ModuleBasedConfiguration> SettingsEditor createEditor(T configuration) {
        return null;
    }

    public String getEditorTitle() {
        return null;
    }

    public String getName() {
        return "snapshooter";
    }

    public <T extends ModuleBasedConfiguration> Icon getIcon(T runConfiguration) {
        return null;
    }

    public void readExternal(ModuleBasedConfiguration runConfiguration, Element element) throws InvalidDataException {
    }

    public void writeExternal(ModuleBasedConfiguration runConfiguration, Element element) throws WriteExternalException {
    }

    public <T extends ModuleBasedConfiguration> void patchConfiguration(T runJavaConfiguration) {
    }

    public <T extends ModuleBasedConfiguration> void checkConfiguration(T runJavaConfiguration) throws RuntimeConfigurationException {
    }
}

