/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import java.awt.Component;
import javax.swing.JComponent;

public abstract class RadAbstractIndexedLayoutManager
extends RadLayoutManager {
    @Override
    public void addComponentToContainer(RadContainer container, RadComponent component, int index) {
        container.getDelegee().add((Component)component.getDelegee(), index);
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public void writeChildConstraints(XmlWriter writer, RadComponent child) {
    }

    @Override
    public void addSnapshotComponent(JComponent parent, JComponent child, RadContainer container, RadComponent component) {
        container.addComponent(component);
    }

    @Override
    public boolean canMoveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        if (colDelta == 1 || colDelta == -1) {
            int newIndex = c.getParent().indexOfComponent(c) + colDelta;
            return newIndex >= 0 && newIndex < c.getParent().getComponentCount();
        }
        return false;
    }

    @Override
    public void moveComponent(RadComponent c, int rowDelta, int colDelta, int rowSpanDelta, int colSpanDelta) {
        RadContainer container = c.getParent();
        int newIndex = container.indexOfComponent(c) + colDelta;
        container.removeComponent(c);
        container.addComponent(c, newIndex);
    }
}

