/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.editors;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ListEditorDialog
extends DialogWrapper {
    private JPanel myRootPanel;
    private JTextArea myLinesTextArea;

    protected ListEditorDialog(Project project, String propertyName) {
        super(project, true);
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(UIDesignerBundle.message("list.editor.title", propertyName));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "UIDesigner.ListEditorDialog";
    }

    public String[] getValue() {
        String text = this.myLinesTextArea.getText();
        if (text.length() == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        return text.split("\n");
    }

    public void setValue(String[] value) {
        this.myLinesTextArea.setText(value == null ? "" : StringUtil.join((String[])value, (String)"\n"));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLinesTextArea;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JPanel jPanel;
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(200, 300), null));
        this.myLinesTextArea = jTextArea = new JTextArea();
        jScrollPane.setViewportView(jTextArea);
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/UIDesignerBundle").getString("list.editor.prompt"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

