/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.GroupItem;
import com.intellij.uiDesigner.palette.Palette;
import javax.swing.Icon;

public class DeleteComponentAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
        if (project == null || selectedItem == null || groupItem == null) {
            return;
        }
        if (!selectedItem.isRemovable()) {
            Messages.showInfoMessage((Project)project, (String)UIDesignerBundle.message("error.cannot.remove.default.palette", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        int rc = Messages.showYesNoDialog((Project)project, (String)UIDesignerBundle.message("delete.component.prompt", selectedItem.getClassShortName()), (String)UIDesignerBundle.message("delete.component.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        Palette palette = Palette.getInstance(project);
        palette.removeItem(groupItem, selectedItem);
        palette.fireGroupsChanged();
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        ComponentItem selectedItem = (ComponentItem)e.getData(ComponentItem.DATA_KEY);
        GroupItem groupItem = (GroupItem)e.getData(GroupItem.DATA_KEY);
        e.getPresentation().setEnabled(project != null && selectedItem != null && groupItem != null && !selectedItem.isAnyComponent() && selectedItem.isRemovable());
    }
}

