/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.designSurface.ComponentDragObject;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public abstract class EventProcessor {
    private Cursor myCursor;

    public final Cursor getCursor() {
        return this.myCursor;
    }

    public final void setCursor(Cursor cursor) {
        this.myCursor = cursor;
    }

    protected abstract void processKeyEvent(KeyEvent var1);

    protected abstract void processMouseEvent(MouseEvent var1);

    protected abstract boolean cancelOperation();

    public boolean isDragActive() {
        return false;
    }

    public boolean needMousePressed() {
        return false;
    }

    protected static ComponentDropLocation.Direction directionFromKey(int keyCode) {
        switch (keyCode) {
            case 39: {
                return ComponentDropLocation.Direction.RIGHT;
            }
            case 37: {
                return ComponentDropLocation.Direction.LEFT;
            }
            case 38: {
                return ComponentDropLocation.Direction.UP;
            }
            case 40: {
                return ComponentDropLocation.Direction.DOWN;
            }
            case 35: {
                return ComponentDropLocation.Direction.RIGHT;
            }
            case 36: {
                return ComponentDropLocation.Direction.LEFT;
            }
            case 33: {
                return ComponentDropLocation.Direction.UP;
            }
            case 34: {
                return ComponentDropLocation.Direction.DOWN;
            }
        }
        return null;
    }

    private static boolean isMoveToLast(int keyCode) {
        return keyCode == 36 || keyCode == 35 || keyCode == 33 || keyCode == 34;
    }

    protected static ComponentDropLocation moveDropLocation(GuiEditor editor, ComponentDropLocation location, ComponentDragObject dragObject, KeyEvent e) {
        ComponentDropLocation.Direction dir = EventProcessor.directionFromKey(e.getKeyCode());
        boolean moveToLast = EventProcessor.isMoveToLast(e.getKeyCode());
        if (dir != null && location != null) {
            ComponentDropLocation adjacentLocation;
            e.consume();
            if (moveToLast) {
                ComponentDropLocation lastLocation = location;
                for (adjacentLocation = location.getAdjacentLocation(dir); adjacentLocation != null; adjacentLocation = adjacentLocation.getAdjacentLocation(dir)) {
                    if (!adjacentLocation.canDrop(dragObject)) continue;
                    lastLocation = adjacentLocation;
                }
                adjacentLocation = lastLocation;
            } else {
                for (adjacentLocation = location.getAdjacentLocation(dir); adjacentLocation != null && !adjacentLocation.canDrop(dragObject); adjacentLocation = adjacentLocation.getAdjacentLocation(dir)) {
                }
            }
            if (adjacentLocation != null && adjacentLocation.canDrop(dragObject)) {
                adjacentLocation.placeFeedback(editor.getActiveDecorationLayer(), dragObject);
                return adjacentLocation;
            }
        }
        return location;
    }
}

