/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.CommonBundle;
import com.intellij.compiler.PsiClassWriter;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectClasspathTraversing;
import com.intellij.openapi.roots.ProjectRootsTraversing;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.compiler.AsmCodeGenerator;
import com.intellij.uiDesigner.compiler.FormErrorInfo;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.make.CopyResourcesUtil;
import com.intellij.uiDesigner.make.Form2ByteCodeCompiler;
import com.intellij.uiDesigner.make.PreviewNestedFormLoader;
import com.intellij.util.PathsList;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;

public final class PreviewFormAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.actions.PreviewFormAction");
    private static final String CLASS_TO_BIND_NAME = "FormPreviewFrame";
    @NonNls
    private static final String RUNTIME_BUNDLE_PREFIX = "RuntimeBundle";
    @NonNls
    public static final String PREVIEW_BINDING_FIELD = "myComponent";

    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getActiveEditor(e.getDataContext());
        if (editor != null) {
            PreviewFormAction.showPreviewFrame(editor.getModule(), editor.getFile(), e.getDataContext(), editor.getStringDescriptorLocale());
        }
    }

    public void update(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getActiveEditor(e.getDataContext());
        if (editor == null) {
            e.getPresentation().setVisible(false);
            return;
        }
        VirtualFile file = editor.getFile();
        e.getPresentation().setVisible(FileDocumentManager.getInstance().getDocument(file) != null && FileTypeManager.getInstance().getFileTypeByFile(file) == StdFileTypes.GUI_DESIGNER_FORM);
    }

    private static void showPreviewFrame(final @NotNull Module module, final @NotNull VirtualFile formFile, final DataContext dataContext, final @Nullable Locale stringDescriptorLocale) {
        LwRootContainer rootContainer;
        String tempPath;
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/actions/PreviewFormAction.showPreviewFrame must not be null");
        }
        if (formFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/actions/PreviewFormAction.showPreviewFrame must not be null");
        }
        try {
            File tempDirectory = FileUtil.createTempDirectory((String)"FormPreview", (String)"");
            tempPath = tempDirectory.getAbsolutePath();
            CopyResourcesUtil.copyFormsRuntime(tempPath, true);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.toString()), (String)CommonBundle.getErrorTitle());
            return;
        }
        final PathsList sources = ProjectRootsTraversing.collectRoots((Module)module, (ProjectRootsTraversing.RootTraversePolicy)ProjectRootsTraversing.PROJECT_SOURCES);
        String classPath = ProjectRootsTraversing.collectRoots((Module)module, (ProjectRootsTraversing.RootTraversePolicy)ProjectClasspathTraversing.FULL_CLASSPATH_RECURSIVE).getPathsString() + File.pathSeparator + sources.getPathsString() + File.pathSeparator + tempPath;
        URLClassLoader loader = Form2ByteCodeCompiler.createClassLoader(classPath);
        Document doc = FileDocumentManager.getInstance().getDocument(formFile);
        try {
            rootContainer = Utils.getRootContainer((String)doc.getText(), (PropertiesProvider)new CompiledClassPropertiesProvider((ClassLoader)loader));
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.read.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage()), (String)CommonBundle.getErrorTitle());
            return;
        }
        if (rootContainer.getComponentCount() == 0) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.empty.form", formFile.getPath().replace('/', File.separatorChar)), (String)CommonBundle.getErrorTitle());
            return;
        }
        PreviewFormAction.setPreviewBindings(rootContainer, CLASS_TO_BIND_NAME);
        try {
            PreviewNestedFormLoader nestedFormLoader = new PreviewNestedFormLoader(module, tempPath, loader);
            File tempFile = CopyResourcesUtil.copyClass(tempPath, CLASS_TO_BIND_NAME, true);
            CopyResourcesUtil.copyClass(tempPath, "FormPreviewFrame$MyExitAction", true);
            CopyResourcesUtil.copyClass(tempPath, "FormPreviewFrame$MyPackAction", true);
            CopyResourcesUtil.copyClass(tempPath, "FormPreviewFrame$MySetLafAction", true);
            Locale locale = Locale.getDefault();
            if (locale.getCountry().length() > 0 && locale.getLanguage().length() > 0) {
                CopyResourcesUtil.copyProperties(tempPath, "RuntimeBundle_" + locale.getLanguage() + "_" + locale.getCountry() + ".properties");
            }
            if (locale.getLanguage().length() > 0) {
                CopyResourcesUtil.copyProperties(tempPath, "RuntimeBundle_" + locale.getLanguage() + ".properties");
            }
            CopyResourcesUtil.copyProperties(tempPath, "RuntimeBundle_" + locale.getLanguage() + ".properties");
            CopyResourcesUtil.copyProperties(tempPath, "RuntimeBundle.properties");
            AsmCodeGenerator codeGenerator = new AsmCodeGenerator(rootContainer, (ClassLoader)loader, (NestedFormLoader)nestedFormLoader, true, (ClassWriter)new PsiClassWriter(module));
            codeGenerator.patchFile(tempFile);
            FormErrorInfo[] errors = codeGenerator.getErrors();
            if (errors.length != 0) {
                Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), errors[0].getErrorMessage()), (String)CommonBundle.getErrorTitle());
                return;
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage() != null ? e.getMessage() : e.toString()), (String)CommonBundle.getErrorTitle());
            return;
        }
        final HashSet bundleSet = new HashSet();
        FormEditingUtil.iterateStringDescriptors((IComponent)rootContainer, new FormEditingUtil.StringDescriptorVisitor<IComponent>(){

            @Override
            public boolean visit(IComponent component, StringDescriptor descriptor) {
                if (descriptor.getBundleName() != null) {
                    bundleSet.add((Object)descriptor.getDottedBundleName());
                }
                return true;
            }
        });
        if (bundleSet.size() > 0) {
            HashSet virtualFiles = new HashSet();
            HashSet modules = new HashSet();
            PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance((Project)module.getProject());
            for (String bundleName : bundleSet) {
                for (PropertiesFile propFile : manager.findPropertiesFiles(module, bundleName)) {
                    virtualFiles.add((Object)propFile.getVirtualFile());
                    modules.add((Object)ModuleUtil.findModuleForFile((VirtualFile)propFile.getVirtualFile(), (Project)module.getProject()));
                }
            }
            FileSetCompileScope scope = new FileSetCompileScope((Collection)virtualFiles, (Module[])modules.toArray((Object[])new Module[0]));
            CompilerManager.getInstance((Project)module.getProject()).make((CompileScope)scope, new CompileStatusNotification(){

                public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    if (!aborted && errors == 0) {
                        PreviewFormAction.runPreviewProcess(tempPath, sources, module, formFile, dataContext, stringDescriptorLocale);
                    }
                }
            });
        } else {
            PreviewFormAction.runPreviewProcess(tempPath, sources, module, formFile, dataContext, stringDescriptorLocale);
        }
    }

    public static void setPreviewBindings(LwRootContainer rootContainer, String classToBindName) {
        rootContainer.setClassToBind(classToBindName);
        FormEditingUtil.iterate((IComponent)rootContainer, new FormEditingUtil.ComponentVisitor<LwComponent>(){

            @Override
            public boolean visit(LwComponent iComponent) {
                iComponent.setBinding(null);
                return true;
            }
        });
        if (rootContainer.getComponentCount() == 1) {
            ((LwComponent)rootContainer.getComponent(0)).setBinding(PREVIEW_BINDING_FIELD);
        }
    }

    private static void runPreviewProcess(String tempPath, PathsList sources, final Module module, VirtualFile formFile, final DataContext dataContext, @Nullable Locale stringDescriptorLocale) {
        JavaParameters parameters = new JavaParameters();
        parameters.getClassPath().add(tempPath);
        parameters.getClassPath().add(PathManager.findFileInLibDirectory((String)"jgoodies-forms.jar").getAbsolutePath());
        List paths = sources.getPathList();
        for (String path : paths) {
            parameters.getClassPath().add(path);
        }
        try {
            parameters.configureByModule(module, 3);
        }
        catch (CantRunException e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage()), (String)CommonBundle.getErrorTitle());
            return;
        }
        parameters.setMainClass(CLASS_TO_BIND_NAME);
        parameters.setWorkingDirectory(tempPath);
        if (stringDescriptorLocale != null && stringDescriptorLocale.getDisplayName().length() > 0) {
            parameters.getVMParametersList().add("-Duser.language=" + stringDescriptorLocale.getLanguage());
        }
        try {
            MyRunProfile profile = new MyRunProfile(module, parameters, UIDesignerBundle.message("progress.preview.started", formFile.getPresentableUrl()));
            ProgramRunner defaultRunner = RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)profile);
            LOG.assertTrue(defaultRunner != null);
            defaultRunner.execute(DefaultRunExecutor.getRunExecutorInstance(), new ExecutionEnvironment((RunProfile)profile, new DataContext(){

                public Object getData(String dataId) {
                    if (PlatformDataKeys.PROJECT.is(dataId)) {
                        return module.getProject();
                    }
                    return dataContext.getData(dataId);
                }
            }));
        }
        catch (ExecutionException e) {
            Messages.showErrorDialog((Project)module.getProject(), (String)UIDesignerBundle.message("error.cannot.preview.form", formFile.getPath().replace('/', File.separatorChar), e.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static final class MyRunProfile
    implements ModuleRunProfile {
        private final Module myModule;
        private final JavaParameters myParams;
        private final String myStatusbarMessage;

        public MyRunProfile(Module module, JavaParameters params, String statusbarMessage) {
            this.myModule = module;
            this.myParams = params;
            this.myStatusbarMessage = statusbarMessage;
        }

        public Icon getIcon() {
            return null;
        }

        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile.getState must not be null");
            }
            if (env == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile.getState must not be null");
            }
            JavaCommandLineState state = new JavaCommandLineState(env){

                protected JavaParameters createJavaParameters() {
                    return MyRunProfile.this.myParams;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
                    ExecutionResult executionResult;
                    if (executor == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile$1.execute must not be null");
                    }
                    if (runner == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile$1.execute must not be null");
                    }
                    try {
                        executionResult = super.execute(executor, runner);
                    }
                    catch (Throwable throwable) {
                        Project project = MyRunProfile.this.myModule.getProject();
                        SwingUtilities.invokeLater(new Runnable(project){
                            final /* synthetic */ Project val$project;
                            {
                                this.val$project = project;
                            }

                            @Override
                            public void run() {
                                WindowManager.getInstance().getStatusBar(this.val$project).setInfo(MyRunProfile.this.myStatusbarMessage);
                            }
                        });
                        throw throwable;
                    }
                    Project project = MyRunProfile.this.myModule.getProject();
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return executionResult;
                }
            };
            state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.myModule.getProject()));
            return state;
        }

        public String getName() {
            return UIDesignerBundle.message("title.form.preview", new Object[0]);
        }

        public void checkConfiguration() throws RuntimeConfigurationException {
        }

        @NotNull
        public Module[] getModules() {
            Module[] moduleArray = new Module[]{this.myModule};
            if (moduleArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/actions/PreviewFormAction$MyRunProfile.getModules must not return null");
            }
            return moduleArray;
        }
    }
}

