/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import net.n3.nanoxml.CDATAReader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.XMLEntityResolver;
import net.n3.nanoxml.XMLUtil;

public class NonValidator
implements IXMLValidator {
    protected IXMLEntityResolver parameterEntityResolver;
    protected Hashtable attributeDefaultValues = new Hashtable();
    protected Stack currentElements = new Stack();

    public NonValidator() {
        this.parameterEntityResolver = new XMLEntityResolver();
    }

    public void setParameterEntityResolver(IXMLEntityResolver resolver) {
        this.parameterEntityResolver = resolver;
    }

    public IXMLEntityResolver getParameterEntityResolver() {
        return this.parameterEntityResolver;
    }

    public void parseDTD(String publicID, IXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
        XMLUtil.skipWhitespace(reader, null);
        int origLevel = reader.getStreamLevel();
        while (true) {
            String str;
            char ch;
            if ((ch = (str = XMLUtil.read(reader, '%')).charAt(0)) == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                continue;
            }
            if (ch == '<') {
                this.processElement(reader, entityResolver);
            } else {
                if (ch == ']') {
                    return;
                }
                XMLUtil.errorInvalidInput(reader.getSystemID(), reader.getLineNr(), str);
            }
            do {
                ch = reader.read();
                if (!external || reader.getStreamLevel() >= origLevel) continue;
                reader.unread(ch);
                return;
            } while (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r');
            reader.unread(ch);
        }
    }

    protected void processElement(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        if (ch != '!') {
            XMLUtil.skipTag(reader);
            return;
        }
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        switch (ch) {
            case '-': {
                XMLUtil.skipComment(reader);
                break;
            }
            case '[': {
                this.processConditionalSection(reader, entityResolver);
                break;
            }
            case 'E': {
                this.processEntity(reader, entityResolver);
                break;
            }
            case 'A': {
                this.processAttList(reader, entityResolver);
                break;
            }
            default: {
                XMLUtil.skipTag(reader);
            }
        }
    }

    protected void processConditionalSection(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        int ch2;
        XMLUtil.skipWhitespace(reader, null);
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        if (ch != 'I') {
            XMLUtil.skipTag(reader);
            return;
        }
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        switch (ch) {
            case 'G': {
                this.processIgnoreSection(reader, entityResolver);
                return;
            }
            case 'N': {
                break;
            }
            default: {
                XMLUtil.skipTag(reader);
                return;
            }
        }
        if (!XMLUtil.checkLiteral(reader, "CLUDE")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        if (ch != '[') {
            XMLUtil.skipTag(reader);
            return;
        }
        CDATAReader subreader = new CDATAReader(reader);
        StringBuffer buf = new StringBuffer(1024);
        while ((ch2 = subreader.read()) >= 0) {
            buf.append((char)ch2);
        }
        ((Reader)subreader).close();
        reader.startNewStream(new StringReader(buf.toString()));
    }

    protected void processIgnoreSection(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, "NORE")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        if (ch != '[') {
            XMLUtil.skipTag(reader);
            return;
        }
        CDATAReader subreader = new CDATAReader(reader);
        ((Reader)subreader).close();
    }

    protected void processAttList(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, "TTLIST")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        String str = XMLUtil.read(reader, '%');
        char ch = str.charAt(0);
        while (ch == '%') {
            XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
        }
        reader.unread(ch);
        String elementName = XMLUtil.scanIdentifier(reader);
        XMLUtil.skipWhitespace(reader, null);
        str = XMLUtil.read(reader, '%');
        ch = str.charAt(0);
        while (ch == '%') {
            XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
        }
        Properties props = new Properties();
        while (ch != '>') {
            reader.unread(ch);
            String attName = XMLUtil.scanIdentifier(reader);
            XMLUtil.skipWhitespace(reader, null);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
            while (ch == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                str = XMLUtil.read(reader, '%');
                ch = str.charAt(0);
            }
            if (ch == '(') {
                while (ch != ')') {
                    str = XMLUtil.read(reader, '%');
                    ch = str.charAt(0);
                    while (ch == '%') {
                        XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                        str = XMLUtil.read(reader, '%');
                        ch = str.charAt(0);
                    }
                }
            } else {
                reader.unread(ch);
                XMLUtil.scanIdentifier(reader);
            }
            XMLUtil.skipWhitespace(reader, null);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
            while (ch == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                str = XMLUtil.read(reader, '%');
                ch = str.charAt(0);
            }
            if (ch == '#') {
                str = XMLUtil.scanIdentifier(reader);
                XMLUtil.skipWhitespace(reader, null);
                if (!str.equals("FIXED")) {
                    XMLUtil.skipWhitespace(reader, null);
                    str = XMLUtil.read(reader, '%');
                    ch = str.charAt(0);
                    while (ch == '%') {
                        XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                        str = XMLUtil.read(reader, '%');
                        ch = str.charAt(0);
                    }
                    continue;
                }
            } else {
                reader.unread(ch);
            }
            String value = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
            props.put(attName, value);
            XMLUtil.skipWhitespace(reader, null);
            str = XMLUtil.read(reader, '%');
            ch = str.charAt(0);
            while (ch == '%') {
                XMLUtil.processEntity(str, reader, this.parameterEntityResolver);
                str = XMLUtil.read(reader, '%');
                ch = str.charAt(0);
            }
        }
        if (!props.isEmpty()) {
            this.attributeDefaultValues.put(elementName, props);
        }
    }

    protected void processEntity(IXMLReader reader, IXMLEntityResolver entityResolver) throws Exception {
        if (!XMLUtil.checkLiteral(reader, "NTITY")) {
            XMLUtil.skipTag(reader);
            return;
        }
        XMLUtil.skipWhitespace(reader, null);
        char ch = XMLUtil.readChar(reader, '\u0000');
        if (ch == '%') {
            XMLUtil.skipWhitespace(reader, null);
            entityResolver = this.parameterEntityResolver;
        } else {
            reader.unread(ch);
        }
        String key = XMLUtil.scanIdentifier(reader);
        XMLUtil.skipWhitespace(reader, null);
        ch = XMLUtil.readChar(reader, '%');
        String systemID = null;
        String publicID = null;
        switch (ch) {
            case 'P': {
                if (!XMLUtil.checkLiteral(reader, "UBLIC")) {
                    XMLUtil.skipTag(reader);
                    return;
                }
                XMLUtil.skipWhitespace(reader, null);
                publicID = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, null);
                systemID = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, null);
                XMLUtil.readChar(reader, '%');
                break;
            }
            case 'S': {
                if (!XMLUtil.checkLiteral(reader, "YSTEM")) {
                    XMLUtil.skipTag(reader);
                    return;
                }
                XMLUtil.skipWhitespace(reader, null);
                systemID = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                XMLUtil.skipWhitespace(reader, null);
                XMLUtil.readChar(reader, '%');
                break;
            }
            case '\"': 
            case '\'': {
                reader.unread(ch);
                String value = XMLUtil.scanString(reader, '%', this.parameterEntityResolver);
                entityResolver.addInternalEntity(key, value);
                XMLUtil.skipWhitespace(reader, null);
                XMLUtil.readChar(reader, '%');
                break;
            }
            default: {
                XMLUtil.skipTag(reader);
            }
        }
        if (systemID != null) {
            entityResolver.addExternalEntity(key, publicID, systemID);
        }
    }

    public void elementStarted(String name, String systemId, int lineNr) {
        Properties attribs = (Properties)this.attributeDefaultValues.get(name);
        attribs = attribs == null ? new Properties() : (Properties)attribs.clone();
        this.currentElements.push(attribs);
    }

    public void elementEnded(String name, String systemId, int lineNr) {
    }

    public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        Properties props = (Properties)this.currentElements.pop();
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            extraAttributes.put(key, props.get(key));
        }
    }

    public void attributeAdded(String key, String value, String systemId, int lineNr) {
        Properties props = (Properties)this.currentElements.peek();
        if (props.containsKey(key)) {
            props.remove(key);
        }
    }

    public void PCDataAdded(String systemId, int lineNr) {
    }
}

