/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring;

import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.IncorrectOperationException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.GenerateToStringContext;
import org.jetbrains.generate.tostring.GenerateToStringUtils;
import org.jetbrains.generate.tostring.config.Config;
import org.jetbrains.generate.tostring.config.ConflictResolutionPolicy;
import org.jetbrains.generate.tostring.config.DuplicatePolicy;
import org.jetbrains.generate.tostring.config.DuplicatonPolicy;
import org.jetbrains.generate.tostring.config.InsertAfterEqualsHashCodeStrategy;
import org.jetbrains.generate.tostring.config.InsertAtCaretStrategy;
import org.jetbrains.generate.tostring.config.InsertLastStrategy;
import org.jetbrains.generate.tostring.config.InsertNewMethodStrategy;
import org.jetbrains.generate.tostring.config.InsertWhere;
import org.jetbrains.generate.tostring.config.ReplacePolicy;
import org.jetbrains.generate.tostring.element.ClassElement;
import org.jetbrains.generate.tostring.element.Element;
import org.jetbrains.generate.tostring.element.ElementComparator;
import org.jetbrains.generate.tostring.element.ElementFactory;
import org.jetbrains.generate.tostring.element.ElementUtils;
import org.jetbrains.generate.tostring.exception.GenerateCodeException;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.psi.PsiAdapterFactory;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.util.StringUtil;
import org.jetbrains.generate.tostring.velocity.VelocityFactory;
import org.jetbrains.generate.tostring.view.MethodExistsDialog;

public class GenerateToStringWorker {
    private static final Logger logger = Logger.getInstance((String)"#org.jetbrains.generate.tostring.GenerateToStringWorker");
    private final PsiElementFactory elementFactory;
    private final CodeStyleManager codeStyleManager;
    private final Editor editor;
    private final PsiFile containingFile;
    private final PsiClass clazz;
    private final PsiAdapter psi;
    private final Config config;
    private final Project project;
    private final boolean hasOverrideAnnotation;

    public GenerateToStringWorker(PsiClass clazz, Editor editor, boolean insertAtOverride) {
        this.clazz = clazz;
        this.project = clazz.getProject();
        this.psi = PsiAdapterFactory.getPsiAdapter();
        this.editor = editor;
        this.elementFactory = JavaPsiFacade.getInstance((Project)this.project).getElementFactory();
        this.codeStyleManager = CodeStyleManager.getInstance((Project)this.project);
        this.containingFile = clazz.getContainingFile();
        this.config = GenerateToStringContext.getConfig();
        this.hasOverrideAnnotation = insertAtOverride;
    }

    public void execute(Collection<PsiMember> members, TemplateResource template) throws IncorrectOperationException, GenerateCodeException {
        ConflictResolutionPolicy resolutionPolicy = this.exitsMethodDialog(template);
        resolutionPolicy.setNewMethodStrategy(GenerateToStringWorker.getStrategy(this.config.getInsertNewMethodInitialOption()));
        HashMap<String, String> params = new HashMap<String, String>();
        this.beforeCreateToStringMethod(params, template);
        PsiMethod method = this.createToStringMethod(members, resolutionPolicy, params, template);
        if (method != null) {
            this.afterCreateToStringMethod(method, params, template);
        }
    }

    private static InsertNewMethodStrategy getStrategy(InsertWhere option) {
        switch (option) {
            case AFTER_EQUALS_AND_HASHCODE: {
                return InsertAfterEqualsHashCodeStrategy.getInstance();
            }
            case AT_CARET: {
                return InsertAtCaretStrategy.getInstance();
            }
            case AT_THE_END_OF_A_CLASS: {
                return InsertLastStrategy.getInstance();
            }
        }
        return InsertLastStrategy.getInstance();
    }

    private ConflictResolutionPolicy exitsMethodDialog(TemplateResource template) {
        DuplicatonPolicy dupPolicy = this.config.getReplaceDialogInitialOption();
        if (dupPolicy == DuplicatonPolicy.ASK) {
            PsiMethod existingMethod = this.psi.findMethodByName(this.clazz, template.getTargetMethodName());
            if (existingMethod != null) {
                return MethodExistsDialog.showDialog(template.getTargetMethodName());
            }
        } else if (dupPolicy == DuplicatonPolicy.REPLACE) {
            return ReplacePolicy.getInstance();
        }
        return DuplicatePolicy.getInstance();
    }

    private void beforeCreateToStringMethod(Map<String, String> params, TemplateResource template) {
        PsiDocComment doc;
        PsiMethod existingMethod = this.psi.findMethodByName(this.clazz, template.getTargetMethodName());
        if (existingMethod != null && existingMethod.getDocComment() != null && (doc = existingMethod.getDocComment()) != null) {
            params.put("existingJavaDoc", doc.getText());
        }
    }

    @Nullable
    private PsiMethod createToStringMethod(Collection<PsiMember> selectedMembers, ConflictResolutionPolicy policy, Map<String, String> params, TemplateResource template) throws IncorrectOperationException, GenerateCodeException {
        String body = this.velocityGenerateCode(selectedMembers, params, template.getMethodBody());
        if (logger.isDebugEnabled()) {
            logger.debug("Method body generated from Velocity:\n" + body);
        }
        body = StringUtil.fixLineBreaks(body);
        PsiMethod newMethod = this.elementFactory.createMethodFromText(template.getMethodSignature() + " { " + body + " }", null);
        this.codeStyleManager.reformat((PsiElement)newMethod);
        PsiMethod existingMethod = this.clazz.findMethodBySignature(newMethod, false);
        PsiMethod toStringMethod = policy.applyMethod(this.clazz, existingMethod, newMethod, this.editor);
        if (toStringMethod == null) {
            return null;
        }
        if (this.hasOverrideAnnotation) {
            GenerateToStringWorker.annotate(toStringMethod, "java.lang.Override");
        }
        if (template.hasAnnotations()) {
            String[] annotations = template.getAnnotations();
            for (int i = annotations.length - 1; i > -1; --i) {
                String text = annotations[i];
                this.psi.addAnnotationToMethod(this.elementFactory, toStringMethod, text);
            }
        }
        String existingJavaDoc = params.get("existingJavaDoc");
        String newJavaDoc = template.getJavaDoc();
        if (existingJavaDoc != null || newJavaDoc != null) {
            newJavaDoc = this.velocityGenerateCode(selectedMembers, params, newJavaDoc);
            if (logger.isDebugEnabled()) {
                logger.debug("JavaDoc body generated from Velocity:\n" + newJavaDoc);
            }
            this.applyJavaDoc(toStringMethod, this.elementFactory, this.codeStyleManager, existingJavaDoc, newJavaDoc);
        }
        return toStringMethod;
    }

    private void applyJavaDoc(PsiMethod newMethod, PsiElementFactory elementFactory, CodeStyleManager codeStyleManager, String existingJavaDoc, String newJavaDoc) throws IncorrectOperationException {
        String text = newJavaDoc != null ? newJavaDoc : existingJavaDoc;
        this.psi.addOrReplaceJavadoc(elementFactory, codeStyleManager, newMethod, text, true);
    }

    private void afterCreateToStringMethod(PsiMethod method, Map<String, String> params, TemplateResource template) throws IncorrectOperationException {
        int offset;
        PsiMethod newMethod;
        if (this.containingFile instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)this.containingFile;
            String javaCode = method.getText();
            if (javaCode.indexOf("Arrays.") > 0 && !this.psi.hasImportStatement(javaFile, "java.util.*") && !this.psi.hasImportStatement(javaFile, "java.util.Arrays")) {
                this.psi.addImportStatement(javaFile, "java.util.*", this.elementFactory);
            }
            if (javaCode.indexOf("Field[]") > 0 && !this.psi.hasImportStatement(javaFile, "java.lang.reflect.*") && !this.psi.hasImportStatement(javaFile, "java.lang.reflect.Field")) {
                this.psi.addImportStatement(javaFile, "java.lang.reflect.*", this.elementFactory);
            }
            if (params.get("autoImportPackages") != null) {
                this.autoImportPackages(javaFile, params.get("autoImportPackages"));
            }
        }
        this.codeStyleManager.reformat((PsiElement)method);
        if (this.config.isJumpToMethod() && this.editor != null && (newMethod = this.psi.findMethodByName(this.clazz, template.getTargetMethodName())) != null && (offset = newMethod.getTextOffset()) > 2) {
            VisualPosition vp = this.editor.offsetToVisualPosition(offset);
            if (logger.isDebugEnabled()) {
                logger.debug("Moving/Scrolling caret to " + vp + " (offset=" + offset + ")");
            }
            this.editor.getCaretModel().moveToVisualPosition(vp);
            this.editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
        }
    }

    private void autoImportPackages(PsiJavaFile psiJavaFile, String packageNames) throws IncorrectOperationException {
        StringTokenizer tok = new StringTokenizer(packageNames, ",");
        while (tok.hasMoreTokens()) {
            String packageName = tok.nextToken().trim();
            if (logger.isDebugEnabled()) {
                logger.debug("Auto importing package: " + packageName);
            }
            this.psi.addImportStatement(psiJavaFile, packageName, this.elementFactory);
        }
    }

    private String velocityGenerateCode(Collection<PsiMember> selectedMembers, Map<String, String> params, String templateMacro) throws GenerateCodeException {
        if (templateMacro == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        try {
            VelocityContext vc = new VelocityContext();
            logger.debug("Velocity Context - adding fields");
            vc.put("fields", ElementUtils.getOnlyAsFieldElements(this.project, this.psi, selectedMembers));
            logger.debug("Velocity Context - adding methods");
            vc.put("methods", ElementUtils.getOnlyAsMethodElements(this.elementFactory, this.psi, selectedMembers));
            logger.debug("Velocity Context - adding members (fields and methods)");
            List<Element> elements = ElementUtils.getOnlyAsFieldAndMethodElements(this.project, this.elementFactory, this.psi, selectedMembers);
            if (this.config.getSortElements() != 0) {
                Collections.sort(elements, new ElementComparator(this.config.getSortElements()));
            }
            vc.put("members", elements);
            ClassElement ce = ElementFactory.newClassElement(this.project, this.clazz, this.psi);
            vc.put("class", (Object)ce);
            if (logger.isDebugEnabled()) {
                logger.debug("Velocity Context - adding class: " + ce);
            }
            vc.put("classname", (Object)(this.config.isUseFullyQualifiedName() ? ce.getQualifiedName() : ce.getName()));
            vc.put("FQClassname", (Object)ce.getQualifiedName());
            if (logger.isDebugEnabled()) {
                logger.debug("Velocity Macro:\n" + templateMacro);
            }
            VelocityEngine velocity = VelocityFactory.getVelocityEngine();
            logger.debug("Executing velocity +++ START +++");
            velocity.evaluate((Context)vc, (Writer)sw, this.getClass().getName(), templateMacro);
            logger.debug("Executing velocity +++ END +++");
            if (vc.get("autoImportPackages") != null) {
                params.put("autoImportPackages", (String)vc.get("autoImportPackages"));
            }
            if (this.config.isAddImplementSerializable() && !ce.isImplements("java.io.Serializable")) {
                this.psi.addImplements(this.project, this.clazz, "java.io.Serializable");
            }
        }
        catch (Exception e) {
            throw new GenerateCodeException("Error in Velocity code generator", e);
        }
        return sw.getBuffer().toString();
    }

    public static void executeGenerateActionLater(final PsiClass clazz, final Editor editor, final Collection<PsiMember> selectedMemebers, final TemplateResource template, final boolean insertAtOverride) {
        Runnable writeCommand = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new GenerateToStringWorker(clazz, editor, insertAtOverride).execute(selectedMemebers, template);
                        }
                        catch (Exception e) {
                            GenerateToStringUtils.handleExeption(clazz.getProject(), e);
                        }
                    }
                });
            }
        };
        PsiAdapterFactory.getPsiAdapter().executeCommand(clazz.getProject(), writeCommand);
    }

    private static void annotate(PsiMethod result, String fqn) throws IncorrectOperationException {
        AddAnnotationFix fix = new AddAnnotationFix(fqn, (PsiModifierListOwner)result, new String[0]);
        Project project = result.getProject();
        if (fix.isAvailable(project, null, result.getContainingFile())) {
            fix.invoke(project, null, result.getContainingFile());
        }
    }
}

