/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.update.AbstractSvnUpdatePanel;

public abstract class SvnUpdateConfigurable
implements Configurable {
    @NonNls
    private static final String HELP_ID = "vcs.subversion.updateProject";
    private AbstractSvnUpdatePanel myPanel;
    private final Project myProject;

    public SvnUpdateConfigurable(Project project) {
        this.myProject = project;
    }

    public String getHelpTopic() {
        return HELP_ID;
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply(SvnConfiguration.getInstance(this.myProject));
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent createComponent() {
        this.myPanel = this.createPanel();
        return this.myPanel.getPanel();
    }

    protected abstract AbstractSvnUpdatePanel createPanel();

    public boolean isModified() {
        return false;
    }

    public void reset() {
        this.myPanel.reset(SvnConfiguration.getInstance(this.myProject));
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    protected Project getProject() {
        return this.myProject;
    }
}

