/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.FilePathByPathComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.update.MultipleRootsEditor;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public abstract class AbstractSvnUpdatePanel {
    protected final SvnVcs myVCS;
    private final Map<FilePath, SvnPanel> myRootToPanel = new LinkedHashMap<FilePath, SvnPanel>();

    public AbstractSvnUpdatePanel(SvnVcs vcs) {
        this.myVCS = vcs;
    }

    protected void init(Collection<FilePath> roots) {
        JPanel configureRootsPanel = this.getRootsPanel();
        configureRootsPanel.setLayout(new BorderLayout());
        ArrayList<FilePath> rootsCopy = new ArrayList<FilePath>(roots);
        Collections.sort(rootsCopy, FilePathByPathComparator.getInstance());
        for (FilePath root : rootsCopy) {
            SVNURL url = this.getUrlFor(root);
            if (url != null) {
                this.myRootToPanel.put(root, this.createRootPanel(root, this.myVCS, roots));
            }
            if (this.myRootToPanel.size() == 1) {
                configureRootsPanel.add((Component)this.myRootToPanel.values().iterator().next().getPanel(), "Center");
                continue;
            }
            MultipleRootsEditor multipleRootsEditor = new MultipleRootsEditor(this.myRootToPanel, this.myVCS.getProject());
            configureRootsPanel.add((Component)multipleRootsEditor.getPanel(), "Center");
        }
    }

    protected abstract SvnPanel createRootPanel(FilePath var1, SvnVcs var2, Collection<FilePath> var3);

    protected abstract JPanel getRootsPanel();

    public void reset(SvnConfiguration configuration) {
        this.getStatusBox().setSelected(configuration.UPDATE_RUN_STATUS);
        this.getDepthBox().setSelectedItem(configuration.UPDATE_DEPTH);
        for (FilePath filePath : this.myRootToPanel.keySet()) {
            this.myRootToPanel.get(filePath).reset(configuration);
        }
    }

    public void apply(SvnConfiguration configuration) throws ConfigurationException {
        configuration.UPDATE_RUN_STATUS = this.getStatusBox().isSelected();
        configuration.UPDATE_DEPTH = this.getDepthBox().getSelectedItem();
        for (FilePath filePath : this.myRootToPanel.keySet()) {
            SvnPanel svnPanel = this.myRootToPanel.get(filePath);
            if (!svnPanel.canApply()) continue;
            svnPanel.apply(configuration);
        }
    }

    @Nullable
    private SVNURL getUrlFor(@NotNull FilePath root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/update/AbstractSvnUpdatePanel.getUrlFor must not be null");
        }
        try {
            SVNWCClient wcClient = this.myVCS.createWCClient();
            SVNInfo info = wcClient.doInfo(root.getIOFile(), SVNRevision.WORKING);
            if (info != null) {
                return info.getURL();
            }
            return null;
        }
        catch (SVNException e) {
            return null;
        }
    }

    protected abstract JComponent getPanel();

    protected abstract JCheckBox getStatusBox();

    protected abstract DepthCombo getDepthBox();
}

