/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.changes.committed.LabeledComboBoxAction;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.idea.svn.SvnBranchMapperManager;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.mergeinfo.SelectBranchAction;

public class SelectWCopyComboAction
extends LabeledComboBoxAction
implements Consumer<String>,
Getter<String> {
    private String myBranch;
    private final MessageBusConnection myMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect();

    public SelectWCopyComboAction() {
        super(SvnBundle.message("committed.changes.action.merge.highlighting.select.wcopy", new Object[0]));
        this.myMessageBusConnection.subscribe(SvnBranchMapperManager.WC_ROOTS_CHANGED, (Object)new SvnBranchMapperManager.WcRootsChangeConsumer(){

            @Override
            public void rootsChanged(final String url, final Collection<String> roots) {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    SelectWCopyComboAction.this.changeList(url, roots);
                } else {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SelectWCopyComboAction.this.changeList(url, roots);
                        }
                    });
                }
            }
        });
    }

    private void changeList(String url, Collection<String> roots) {
        String selected = this.myBranch;
        if (selected != null && selected.equals(url)) {
            Object[] items = roots.toArray();
            Arrays.sort(items);
            this.setModelKeepSelection(new DefaultComboBoxModel<Object>(items));
        }
    }

    protected void selectionChanged(Object selection) {
    }

    private void setModelKeepSelection(DefaultComboBoxModel model) {
        String selected = (String)this.getSelected();
        this.setModel(model);
        if (selected != null) {
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                String current = (String)model.getElementAt(i);
                if (!selected.equals(current)) continue;
                model.setSelectedItem(current);
            }
        }
    }

    public void consume(String s) {
        if (this.myBranch != null && this.myBranch.equals(s)) {
            return;
        }
        this.myBranch = s;
        this.setModelKeepSelection(this.loadItems(this.myBranch));
    }

    private DefaultComboBoxModel loadItems(String s) {
        if (s == null) {
            return SelectBranchAction.EMPTY;
        }
        Set<String> items = SvnBranchMapperManager.getInstance().get(s);
        if (items == null) {
            return SelectBranchAction.EMPTY;
        }
        Object[] itemsArray = ArrayUtil.toStringArray(items);
        Arrays.sort(itemsArray);
        return new DefaultComboBoxModel<Object>(itemsArray);
    }

    protected ComboBoxModel createModel() {
        return this.loadItems(this.myBranch);
    }

    public void deactivate() {
        this.myMessageBusConnection.disconnect();
    }

    public String get() {
        return (String)this.getSelected();
    }
}

