/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PairProcessor;
import java.io.File;
import java.util.Map;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.mergeinfo.AreaMap;
import org.jetbrains.idea.svn.mergeinfo.MergeInfoWorker;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class OneRecursiveShotMergeInfoWorker
implements MergeInfoWorker {
    private final Project myProject;
    private final WCInfo myWCInfo;
    private final AreaMap<String, Map<String, SVNMergeRangeList>> myDataMap;
    private String myFromUrlRelative;

    public OneRecursiveShotMergeInfoWorker(Project project, WCInfo WCInfo2, String fromUrl) {
        this.myProject = project;
        this.myWCInfo = WCInfo2;
        this.myDataMap = new AreaMap(new PairProcessor<String, String>(){

            public boolean process(String parentUrl, String childUrl) {
                if (".".equals(parentUrl)) {
                    return true;
                }
                return SVNPathUtil.isAncestor((String)OneRecursiveShotMergeInfoWorker.this.ensureUrlFromSlash(parentUrl), (String)OneRecursiveShotMergeInfoWorker.this.ensureUrlFromSlash(childUrl));
            }
        });
        String url = SVNPathUtil.getRelativePath((String)this.myWCInfo.getRepositoryRoot(), (String)fromUrl);
        this.myFromUrlRelative = this.ensureUrlFromSlash(url);
    }

    private String ensureUrlFromSlash(String url) {
        return url.startsWith("/") ? url : "/" + url;
    }

    public void prepare() throws SVNException {
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        SVNWCClient client = vcs.createWCClient();
        SVNDepth depth = SvnConfiguration.getInstance((Project)this.myProject).CHECK_NESTED_FOR_QUICK_MERGE ? SVNDepth.INFINITY : SVNDepth.EMPTY;
        client.doGetProperty(new File(this.myWCInfo.getPath()), "svn:mergeinfo", SVNRevision.UNDEFINED, SVNRevision.WORKING, depth, new ISVNPropertyHandler(){

            public void handleProperty(File path, SVNPropertyData property) throws SVNException {
                String key = OneRecursiveShotMergeInfoWorker.this.keyFromFile(path);
                OneRecursiveShotMergeInfoWorker.this.myDataMap.put(key, SVNMergeInfoUtil.parseMergeInfo((StringBuffer)new StringBuffer(OneRecursiveShotMergeInfoWorker.replaceSeparators(property.getValue().getString())), null));
            }

            public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
            }

            public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
            }
        }, null);
    }

    @Override
    public SvnMergeInfoCache.MergeCheckResult isMerged(String relativeToRepoURLPath, long revisionNumber) {
        String relativeToWc = SVNPathUtil.getRelativePath((String)this.myFromUrlRelative, (String)this.ensureUrlFromSlash(relativeToRepoURLPath));
        if (relativeToWc == null) {
            return SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        }
        InfoProcessor processor = new InfoProcessor(relativeToWc, this.myFromUrlRelative, revisionNumber);
        this.myDataMap.getSimiliar(OneRecursiveShotMergeInfoWorker.keyFromPath(relativeToWc), processor);
        return SvnMergeInfoCache.MergeCheckResult.getInstance(processor.isMerged());
    }

    private String keyFromFile(File file) {
        String path = FileUtil.getRelativePath((String)this.myWCInfo.getPath(), (String)file.getAbsolutePath(), (char)File.separatorChar).replace(File.separatorChar, '/');
        return OneRecursiveShotMergeInfoWorker.keyFromPath(path);
    }

    private static String keyFromPath(String path) {
        return SystemInfo.isFileSystemCaseSensitive ? path : path.toUpperCase();
    }

    private static String replaceSeparators(String s) {
        return s.replace('\r', '\n').replace("\n\n", "\n");
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, SVNMergeRangeList>> {
        private final String myWcLevelRelativeSourceUrl;
        private boolean myMerged;
        private final String myFilePathAsked;
        private final long myRevisionAsked;

        public InfoProcessor(String filePathAsked, String wcLevelRelativeSourceUrl, long revisionAsked) {
            this.myFilePathAsked = filePathAsked;
            this.myRevisionAsked = revisionAsked;
            this.myWcLevelRelativeSourceUrl = wcLevelRelativeSourceUrl.startsWith("/") ? wcLevelRelativeSourceUrl : "/" + wcLevelRelativeSourceUrl;
        }

        public boolean isMerged() {
            return this.myMerged;
        }

        public boolean process(String relativeFileSubpath, Map<String, SVNMergeRangeList> map) {
            boolean processed = false;
            boolean self = relativeFileSubpath.equals(this.myFilePathAsked);
            if (map.isEmpty()) {
                this.myMerged = false;
                return true;
            }
            block0: for (Map.Entry<String, SVNMergeRangeList> entry : map.entrySet()) {
                String relativeUrl = entry.getKey();
                boolean urlMatches = false;
                if (".".equals(relativeUrl) || "".equals(relativeUrl)) {
                    urlMatches = true;
                } else {
                    relativeUrl = relativeUrl.startsWith("/") ? relativeUrl : "/" + relativeUrl;
                    urlMatches = SVNPathUtil.isAncestor((String)this.myWcLevelRelativeSourceUrl, (String)relativeUrl);
                }
                if (!urlMatches) continue;
                processed = true;
                SVNMergeRangeList rangesList = entry.getValue();
                for (SVNMergeRange range : rangesList.getRanges()) {
                    boolean inInterval;
                    long startRevision = range.getStartRevision() + 1L;
                    long endRevision = range.getEndRevision();
                    boolean isInheritable = range.isInheritable();
                    boolean bl = inInterval = this.myRevisionAsked >= startRevision && this.myRevisionAsked <= endRevision;
                    if (!isInheritable && !self || !inInterval) continue;
                    this.myMerged = true;
                    break block0;
                }
            }
            return processed;
        }
    }
}

