/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.ignore;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnPropertyService {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.ignore.SvnPropertyService");

    private SvnPropertyService() {
    }

    public static void doAddToIgnoreProperty(SvnVcs activeVcs, Project project, boolean useCommonExtension, VirtualFile[] file, IgnoreInfoGetter getter) throws VcsException {
        IgnorePropertyAdder adder = new IgnorePropertyAdder(activeVcs, project, useCommonExtension);
        adder.execute(file, getter);
    }

    public static void doRemoveFromIgnoreProperty(SvnVcs activeVcs, Project project, boolean useCommonExtension, VirtualFile[] file, IgnoreInfoGetter getter) throws VcsException {
        IgnorePropertyRemover remover = new IgnorePropertyRemover(activeVcs, project, useCommonExtension);
        remover.execute(file, getter);
    }

    public static void doCheckIgnoreProperty(SvnVcs activeVcs, Project project, VirtualFile[] file, IgnoreInfoGetter getter, String extensionPattern, Ref<Boolean> filesOk, Ref<Boolean> extensionOk) {
        IgnorePropertyChecker checker = new IgnorePropertyChecker(activeVcs, project, extensionPattern);
        try {
            checker.execute(file, getter);
        }
        catch (VcsException e) {
            // empty catch block
        }
        filesOk.set((Object)checker.filesOk());
        extensionOk.set((Object)checker.extensionOk());
    }

    @Nullable
    public static Set<String> getIgnoreStringsUnder(SvnVcs vcs, VirtualFile dir) {
        try {
            SVNPropertyValue value;
            SVNPropertyData data = vcs.createWCClient().doGetProperty(new File(dir.getPath()), "svn:ignore", SVNRevision.WORKING, SVNRevision.WORKING);
            SVNPropertyValue sVNPropertyValue = value = data == null ? null : data.getValue();
            if (value != null) {
                HashSet<String> ignorePatterns = new HashSet<String>();
                String propAsString = SVNPropertyValue.getPropertyAsString((SVNPropertyValue)value);
                StringTokenizer st = new StringTokenizer(propAsString, "\r\n ");
                while (st.hasMoreElements()) {
                    String ignorePattern = (String)st.nextElement();
                    ignorePatterns.add(ignorePattern);
                }
                return ignorePatterns;
            }
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    public static void setIgnores(SvnVcs vcs, Collection<String> patterns, File file) throws SVNException {
        SVNWCClient client = vcs.createWCClient();
        StringBuilder sb = new StringBuilder();
        for (String pattern : patterns) {
            sb.append(pattern).append('\n');
        }
        if (!patterns.isEmpty()) {
            String value = sb.toString();
            client.doSetProperty(file, "svn:ignore", SVNPropertyValue.create((String)value), false, SVNDepth.EMPTY, null, null);
        } else {
            client.doSetProperty(file, "svn:ignore", null, false, SVNDepth.EMPTY, null, null);
        }
    }

    private static String getNewPropertyValueForRemove(Collection<String> data, @NotNull String propertyValue) {
        if (propertyValue == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/svn/ignore/SvnPropertyService.getNewPropertyValueForRemove must not be null");
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(propertyValue, "\r\n ");
        while (st.hasMoreElements()) {
            String ignorePattern = (String)st.nextElement();
            if (data.contains(ignorePattern)) continue;
            sb.append(ignorePattern).append('\n');
        }
        return sb.toString();
    }

    private static class IgnorePropertyAdder
    extends IgnorePropertyAddRemoveTemplate {
        private IgnorePropertyAdder(SvnVcs activeVcs, Project project, boolean useCommonExtension) {
            super(activeVcs, project, useCommonExtension);
        }

        @Override
        protected String getNewPropertyValue(Set<String> data, SVNPropertyValue propertyValue) {
            String ignoreString;
            if (data.size() == 1) {
                ignoreString = data.iterator().next();
            } else {
                StringBuilder sb = new StringBuilder();
                for (String name : data) {
                    sb.append(name).append('\n');
                }
                ignoreString = sb.toString();
            }
            return propertyValue == null ? ignoreString : SVNPropertyValue.getPropertyAsString((SVNPropertyValue)propertyValue) + '\n' + ignoreString;
        }
    }

    private static class IgnorePropertyRemover
    extends IgnorePropertyAddRemoveTemplate {
        private IgnorePropertyRemover(SvnVcs activeVcs, Project project, boolean useCommonExtension) {
            super(activeVcs, project, useCommonExtension);
        }

        @Override
        protected String getNewPropertyValue(Set<String> data, SVNPropertyValue propertyValue) {
            if (propertyValue != null) {
                return SvnPropertyService.getNewPropertyValueForRemove(data, SVNPropertyValue.getPropertyAsString((SVNPropertyValue)propertyValue));
            }
            return "";
        }
    }

    private static abstract class IgnorePropertyAddRemoveTemplate
    extends IgnorePropertyWorkTemplate {
        private final Collection<String> exceptions = new ArrayList<String>();
        private final VcsDirtyScopeManager dirtyScopeManager;

        private IgnorePropertyAddRemoveTemplate(SvnVcs activeVcs, Project project, boolean useCommonExtension) {
            super(activeVcs, project, useCommonExtension, false);
            this.dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        }

        @Override
        protected boolean stopIteration() {
            return false;
        }

        protected abstract String getNewPropertyValue(Set<String> var1, SVNPropertyValue var2);

        @Override
        protected void processFolder(VirtualFile folder, File folderDir, Set<String> data, SVNPropertyValue propertyValue) throws SVNException {
            String newValue = this.getNewPropertyValue(data, propertyValue);
            newValue = newValue.trim().length() == 0 ? null : newValue;
            this.myClient.doSetProperty(folderDir, "svn:ignore", SVNPropertyValue.create((String)newValue), false, false, null);
            if (this.myUseCommonExtension) {
                this.dirtyScopeManager.dirDirtyRecursively(folder);
            }
        }

        @Override
        protected void onAfterProcessing(VirtualFile[] file) throws VcsException {
            if (!this.myUseCommonExtension) {
                for (VirtualFile virtualFile : file) {
                    VcsDirtyScopeManager.getInstance((Project)this.myProject).fileDirty(virtualFile);
                }
            }
            if (!this.exceptions.isEmpty()) {
                throw new VcsException(this.exceptions);
            }
        }

        @Override
        protected void onSVNException(SVNException e) {
            this.exceptions.add(e.getMessage());
        }
    }

    private static class IgnorePropertyChecker
    extends IgnorePropertyWorkTemplate {
        private final String myExtensionPattern;
        private boolean myFilesOk;
        private boolean myExtensionOk;

        private IgnorePropertyChecker(SvnVcs activeVcs, Project project, String extensionPattern) {
            super(activeVcs, project, false, true);
            this.myExtensionPattern = extensionPattern;
            this.myExtensionOk = true;
            this.myFilesOk = true;
        }

        @Override
        protected boolean stopIteration() {
            return !this.myFilesOk && !this.myExtensionOk;
        }

        @Override
        protected void processFolder(VirtualFile folder, File folderDir, Set<String> data, SVNPropertyValue propertyValue) throws SVNException {
            if (propertyValue == null) {
                this.myFilesOk = false;
                this.myExtensionOk = false;
                return;
            }
            HashSet<String> ignorePatterns = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(SVNPropertyValue.getPropertyAsString((SVNPropertyValue)propertyValue), "\r\n ");
            while (st.hasMoreElements()) {
                String ignorePattern = (String)st.nextElement();
                ignorePatterns.add(ignorePattern);
            }
            this.myExtensionOk &= ignorePatterns.contains(this.myExtensionPattern);
            for (String fileName : data) {
                if (ignorePatterns.contains(fileName)) continue;
                this.myFilesOk = false;
            }
        }

        @Override
        protected void onAfterProcessing(VirtualFile[] file) throws VcsException {
        }

        @Override
        protected void onSVNException(SVNException e) {
            this.myFilesOk = false;
            this.myExtensionOk = false;
        }

        public boolean filesOk() {
            return this.myFilesOk;
        }

        public boolean extensionOk() {
            return this.myExtensionOk;
        }
    }

    private static abstract class IgnorePropertyWorkTemplate {
        protected final SvnVcs myVcs;
        protected final SVNWCClient myClient;
        protected final Project myProject;
        protected final boolean myUseCommonExtension;
        protected final boolean myCanUseCachedProperty;

        protected abstract void processFolder(VirtualFile var1, File var2, Set<String> var3, SVNPropertyValue var4) throws SVNException;

        protected abstract void onAfterProcessing(VirtualFile[] var1) throws VcsException;

        protected abstract void onSVNException(SVNException var1);

        protected abstract boolean stopIteration();

        private IgnorePropertyWorkTemplate(SvnVcs activeVcs, Project project, boolean useCommonExtension, boolean canUseCachedProperty) {
            this.myVcs = activeVcs;
            this.myCanUseCachedProperty = canUseCachedProperty;
            this.myClient = activeVcs.createWCClient();
            this.myProject = project;
            this.myUseCommonExtension = useCommonExtension;
        }

        public void execute(VirtualFile[] file, IgnoreInfoGetter getter) throws VcsException {
            Map<VirtualFile, Set<String>> foldersInfo = getter.getInfo(this.myUseCommonExtension);
            for (Map.Entry<VirtualFile, Set<String>> entry : foldersInfo.entrySet()) {
                if (this.stopIteration()) break;
                File dir = new File(entry.getKey().getPath());
                try {
                    SVNPropertyData data;
                    SVNPropertyValue value = this.myCanUseCachedProperty ? this.myVcs.getPropertyWithCaching(entry.getKey(), "svn:ignore") : ((data = this.myVcs.createWCClient().doGetProperty(dir, "svn:ignore", SVNRevision.UNDEFINED, SVNRevision.WORKING)) == null ? null : data.getValue());
                    this.processFolder(entry.getKey(), dir, entry.getValue(), value);
                }
                catch (SVNException e) {
                    this.onSVNException(e);
                }
            }
            this.onAfterProcessing(file);
        }
    }
}

