/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.ConcurrentTasks;
import com.intellij.util.Consumer;
import java.util.Map;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.history.CopyData;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class FirstInBranch
implements Runnable {
    private final SvnVcs myVcs;
    private final String myFullBranchUrl;
    private final String myFullTrunkUrl;
    private final String myBranchUrl;
    private final String myTrunkUrl;
    private final Consumer<CopyData> myConsumer;

    public FirstInBranch(SvnVcs vcs, String repositoryRoot, String branchUrl, String trunkUrl, Consumer<CopyData> consumer) {
        this.myVcs = vcs;
        this.myConsumer = consumer;
        this.myFullBranchUrl = branchUrl;
        this.myFullTrunkUrl = trunkUrl;
        this.myBranchUrl = this.relativePath(repositoryRoot, branchUrl);
        this.myTrunkUrl = this.relativePath(repositoryRoot, trunkUrl);
    }

    private String relativePath(String parent, String child) {
        String path = SVNPathUtil.getRelativePath((String)parent, (String)child);
        return path.startsWith("/") ? path : "/" + path;
    }

    @Override
    public void run() {
        SVNURL trunkURL;
        SVNURL branchURL;
        try {
            branchURL = SVNURL.parseURIEncoded((String)this.myFullBranchUrl);
            trunkURL = SVNURL.parseURIEncoded((String)this.myFullTrunkUrl);
        }
        catch (SVNException e) {
            this.myConsumer.consume(null);
            return;
        }
        ConcurrentTasks tasks = new ConcurrentTasks(ProgressManager.getInstance().getProgressIndicator(), new Consumer[]{this.createTask(branchURL), this.createTask(trunkURL)});
        tasks.compute();
        if (tasks.isResultKnown()) {
            this.myConsumer.consume(tasks.getResult());
        } else {
            this.myConsumer.consume(null);
        }
    }

    private Consumer<Consumer<CopyData>> createTask(final SVNURL branchURL) {
        return new Consumer<Consumer<CopyData>>(){

            public void consume(final Consumer<CopyData> copyDataConsumer) {
                SVNLogClient logClient = FirstInBranch.this.myVcs.createLogClient();
                long start1 = FirstInBranch.getStart(logClient, branchURL);
                if (start1 > 0L) {
                    SVNRevision start1Rev = SVNRevision.create((long)start1);
                    try {
                        logClient.doLog(branchURL, null, SVNRevision.UNDEFINED, start1Rev, start1Rev, true, true, 1L, new ISVNLogEntryHandler(){

                            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                                FirstInBranch.this.checkForCopy(logEntry, (Consumer<CopyData>)copyDataConsumer);
                            }
                        });
                    }
                    catch (SVNException e) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private static long getStart(SVNLogClient logClient, SVNURL url) {
        final Ref myRevisionCandidate = new Ref((Object)0L);
        try {
            logClient.doLog(url, null, SVNRevision.UNDEFINED, SVNRevision.HEAD, SVNRevision.create((long)0L), true, false, 0L, new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    ProgressManager.checkCanceled();
                    myRevisionCandidate.set((Object)logEntry.getRevision());
                }
            });
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        return (Long)myRevisionCandidate.get();
    }

    private void checkForCopy(SVNLogEntry logEntry, Consumer<CopyData> result) {
        Map map = logEntry.getChangedPaths();
        for (Object o : map.values()) {
            SVNLogEntryPath path = (SVNLogEntryPath)o;
            String localPath = path.getPath();
            String copyPath = path.getCopyPath();
            if ('A' != path.getType()) continue;
            if ((this.myBranchUrl.equals(localPath) || SVNPathUtil.isAncestor((String)localPath, (String)this.myBranchUrl)) && (this.myTrunkUrl.equals(copyPath) || SVNPathUtil.isAncestor((String)copyPath, (String)this.myTrunkUrl))) {
                result.consume((Object)new CopyData(path.getCopyRevision(), logEntry.getRevision(), true));
                continue;
            }
            if (!this.myBranchUrl.equals(copyPath) && !SVNPathUtil.isAncestor((String)copyPath, (String)this.myBranchUrl) || !this.myTrunkUrl.equals(localPath) && !SVNPathUtil.isAncestor((String)localPath, (String)this.myTrunkUrl)) continue;
            result.consume((Object)new CopyData(path.getCopyRevision(), logEntry.getRevision(), false));
        }
    }
}

