/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.vcs.checkout.CheckoutStrategy;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.browser.SvnTrunkCheckoutStrategy;
import org.jetbrains.idea.svn.revision.SvnSelectRevisionPanel;
import org.jetbrains.idea.svn.update.SvnRevisionPanel;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class CheckoutOptionsDialog
extends DialogWrapper {
    private JCheckBox myExternalsCheckbox;
    private JLabel myUrlLabel;
    private JPanel myTopPanel;
    private SvnSelectRevisionPanel svnSelectRevisionPanel;
    private DepthCombo myDepthCombo;
    private JLabel myDepthLabel;
    private JList myLocalTargetList;
    private FixedSizeButton mySelectTarget;
    private final String myRelativePath;

    public CheckoutOptionsDialog(Project project, SVNURL url, File target, VirtualFile root, String relativePath) {
        super(project, true);
        this.myRelativePath = relativePath;
        this.$$$setupUI$$$();
        final String urlText = url.toString();
        this.myUrlLabel.setText(urlText);
        this.fillTargetList(target);
        this.validateTargetSelected();
        this.mySelectTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fcd = new FileChooserDescriptor(false, true, false, false, false, false);
                fcd.setShowFileSystemRoots(true);
                fcd.setTitle(SvnBundle.message("checkout.directory.chooser.title", new Object[0]));
                fcd.setDescription(SvnBundle.message("checkout.directory.chooser.prompt", new Object[0]));
                fcd.setHideIgnored(false);
                VirtualFile[] files = FileChooser.chooseFiles((Component)CheckoutOptionsDialog.this.getContentPane(), (FileChooserDescriptor)fcd, null);
                if (files.length != 1 || files[0] == null) {
                    return;
                }
                CheckoutOptionsDialog.this.fillTargetList(new File(files[0].getPath()));
                CheckoutOptionsDialog.this.validateTargetSelected();
            }
        });
        this.myLocalTargetList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CheckoutOptionsDialog.this.validateTargetSelected();
            }
        });
        this.svnSelectRevisionPanel.setRoot(root);
        this.svnSelectRevisionPanel.setProject(project);
        this.svnSelectRevisionPanel.setUrlProvider(new SvnRevisionPanel.UrlProvider(){

            @Override
            public String getUrl() {
                return urlText;
            }
        });
        this.setTitle(SvnBundle.message("checkout.options.dialog.title", new Object[0]));
        this.myDepthLabel.setLabelFor(this.myDepthCombo);
        this.init();
    }

    private void validateTargetSelected() {
        Object[] objects = this.myLocalTargetList.getSelectedValues();
        boolean disable = objects == null || objects.length != 1;
        this.setOKActionEnabled(!disable);
    }

    private void fillTargetList(File target) {
        DefaultListModel<File> listModel = new DefaultListModel<File>();
        ArrayList<SvnTrunkCheckoutStrategy> strategies = new ArrayList<SvnTrunkCheckoutStrategy>();
        Collections.addAll(strategies, CheckoutStrategy.createAllStrategies((File)target, (File)new File(this.myRelativePath), (boolean)false));
        strategies.add(new SvnTrunkCheckoutStrategy(target, new File(this.myRelativePath), false));
        ArrayList<File> targets = new ArrayList<File>(5);
        for (CheckoutStrategy checkoutStrategy : strategies) {
            File result = checkoutStrategy.getResult();
            if (result == null || targets.contains(result)) continue;
            targets.add(result);
        }
        Collections.sort(targets);
        for (File file : targets) {
            listModel.addElement(file);
        }
        this.myLocalTargetList.setModel(listModel);
        this.myLocalTargetList.setVisibleRowCount(4);
        this.myLocalTargetList.setMinimumSize(new Dimension(20, 80));
        this.myLocalTargetList.setSelectedValue(target, true);
        if (this.myLocalTargetList.getSelectedValues() == null && !targets.isEmpty()) {
            this.myLocalTargetList.setSelectedIndex(0);
        }
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.checkout.options";
    }

    @Nullable
    public File getTarget() {
        Object[] objects = this.myLocalTargetList.getSelectedValues();
        return objects == null || objects.length != 1 ? null : (File)objects[0];
    }

    public SVNDepth getDepth() {
        return this.myDepthCombo.getSelectedItem();
    }

    public boolean isIgnoreExternals() {
        return !this.myExternalsCheckbox.isSelected();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myTopPanel;
    }

    @NotNull
    public SVNRevision getRevision() throws ConfigurationException {
        SVNRevision sVNRevision = this.svnSelectRevisionPanel.getRevision();
        if (sVNRevision == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/svn/dialogs/browser/CheckoutOptionsDialog.getRevision must not return null");
        }
        return sVNRevision;
    }

    private void createUIComponents() {
        this.mySelectTarget = new FixedSizeButton(20);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JList jList;
        JLabel jLabel;
        DepthCombo depthCombo;
        SvnSelectRevisionPanel svnSelectRevisionPanel;
        JCheckBox jCheckBox;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkout.options.checkout.label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        this.myUrlLabel = jLabel2 = new JLabel();
        Font font = jLabel2.getFont();
        jLabel2.setFont(new Font(font.getName(), 1, font.getSize()));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel2, gridBagConstraints2);
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkout.options.destination.label"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel4, gridBagConstraints3);
        this.myExternalsCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkout.options.externals.label"));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.gridwidth = 3;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jCheckBox, gridBagConstraints4);
        JSeparator jSeparator = new JSeparator();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 5;
        gridBagConstraints5.gridwidth = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.anchor = 15;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jSeparator, gridBagConstraints5);
        this.svnSelectRevisionPanel = svnSelectRevisionPanel = new SvnSelectRevisionPanel();
        JComponent jComponent = svnSelectRevisionPanel.$$$getRootComponent$$$();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.gridwidth = 4;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jComponent, gridBagConstraints6);
        this.myDepthCombo = depthCombo = new DepthCombo();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 2;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)depthCombo, gridBagConstraints7);
        this.myDepthLabel = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.description"));
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.depth.text"));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 0;
        gridBagConstraints8.gridy = 3;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
        jPanel2.add((Component)jLabel, gridBagConstraints8);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.gridx = 2;
        gridBagConstraints9.gridy = 1;
        gridBagConstraints9.fill = 1;
        jPanel2.add((Component)jScrollPane, gridBagConstraints9);
        this.myLocalTargetList = jList = new JList();
        jList.setSelectionMode(0);
        jScrollPane.setViewportView(jList);
        FixedSizeButton fixedSizeButton = this.mySelectTarget;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.gridx = 3;
        gridBagConstraints10.gridy = 1;
        gridBagConstraints10.anchor = 11;
        jPanel2.add((Component)fixedSizeButton, gridBagConstraints10);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

