/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.SvnBundle;

public class SSHCredentialsDialog
extends DialogWrapper
implements ActionListener,
DocumentListener {
    private boolean myAllowSave;
    private String myUserName;
    private String myRealm;
    private JTextField myUserNameText;
    private JCheckBox myAllowSaveCheckBox;
    private JPasswordField myPasswordText;
    private JPasswordField myPassphraseText;
    private TextFieldWithBrowseButton myKeyFileText;
    private JRadioButton myPasswordButton;
    private JRadioButton myKeyButton;
    private JLabel myPasswordLabel;
    private JLabel myKeyFileLabel;
    private JLabel myPortLabel;
    private JTextField myPortField;
    private JLabel myPassphraseLabel;
    private final Project myProject;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.authentication";
    @NonNls
    private static final String USER_HOME_PROPERTY = "user.home";

    protected SSHCredentialsDialog(Project project, String realm, String userName, boolean allowSave, int port) {
        super(project, true);
        this.myProject = project;
        this.myRealm = realm;
        this.myUserName = userName;
        this.myAllowSave = allowSave;
        this.setResizable(true);
        this.getHelpAction().setEnabled(true);
        this.init();
        this.myPortField.setText("" + port);
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = new Insets(2, 2, 2, 2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 3;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel label = new JLabel(SvnBundle.message("label.ssh.authentication.realm", this.myRealm));
        panel.add((Component)label, gb);
        ++gb.gridy;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        label = new JLabel(SvnBundle.message("label.ssh.user.name", new Object[0]));
        panel.add((Component)label, gb);
        gb.gridx = 1;
        gb.gridwidth = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        this.myUserNameText = new JTextField();
        panel.add((Component)this.myUserNameText, gb);
        label.setLabelFor(this.myUserNameText);
        if (this.myUserName != null) {
            this.myUserNameText.setText(this.myUserName);
        }
        this.myUserNameText.selectAll();
        this.myUserNameText.getDocument().addDocumentListener(this);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.fill = 0;
        gb.gridwidth = 3;
        this.myPasswordButton = new JRadioButton(SvnBundle.message("radio.ssh.authentication.with.password", new Object[0]));
        panel.add((Component)this.myPasswordButton, gb);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myPasswordLabel = new JLabel(SvnBundle.message("label.ssh.password", new Object[0]));
        panel.add((Component)this.myPasswordLabel, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myPasswordText = new JPasswordField();
        panel.add((Component)this.myPasswordText, gb);
        this.myPasswordLabel.setLabelFor(this.myPasswordText);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.fill = 0;
        gb.gridwidth = 3;
        this.myKeyButton = new JRadioButton(SvnBundle.message("radio.ssh.authentication.private.key", new Object[0]));
        panel.add((Component)this.myKeyButton, gb);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myKeyFileLabel = new JLabel(SvnBundle.message("label.ssh.key.file", new Object[0]));
        panel.add((Component)this.myKeyFileLabel, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myKeyFileText = new TextFieldWithBrowseButton((ActionListener)this);
        this.myKeyFileText.setEditable(false);
        panel.add((Component)this.myKeyFileText, gb);
        this.myKeyFileLabel.setLabelFor((Component)this.myKeyFileText);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myPassphraseLabel = new JLabel(SvnBundle.message("label.ssh.passphrase", new Object[0]));
        panel.add((Component)this.myPassphraseLabel, gb);
        gb.gridx = 1;
        gb.weightx = 1.0;
        gb.gridwidth = 2;
        gb.fill = 2;
        this.myPassphraseText = new JPasswordField(30);
        panel.add((Component)this.myPassphraseText, gb);
        this.myPassphraseText.getDocument().addDocumentListener(this);
        this.myPassphraseLabel.setLabelFor(this.myPassphraseText);
        ++gb.gridy;
        gb.weightx = 0.0;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.fill = 0;
        gb.gridwidth = 1;
        this.myPortLabel = new JLabel(SvnBundle.message("label.ssh.port", new Object[0]));
        panel.add((Component)this.myPortLabel, gb);
        gb.gridx = 1;
        gb.weightx = 0.0;
        gb.gridwidth = 2;
        gb.fill = 0;
        this.myPortField = new JTextField();
        this.myPortField.setColumns(6);
        panel.add((Component)this.myPortField, gb);
        this.myPortLabel.setLabelFor(this.myPortField);
        this.myPortField.setText("22");
        this.myPortField.setMinimumSize(this.myPortField.getPreferredSize());
        this.myPortField.getDocument().addDocumentListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.myPasswordButton);
        group.add(this.myKeyButton);
        group.setSelected(this.myPasswordButton.getModel(), true);
        group.setSelected(this.myPasswordButton.getModel(), false);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 3;
        gb.weightx = 1.0;
        gb.anchor = 17;
        gb.fill = 2;
        this.myAllowSaveCheckBox = new JCheckBox(SvnBundle.message("checkbox.ssh.keep.for.current.session", new Object[0]));
        panel.add((Component)this.myAllowSaveCheckBox, gb);
        if (!this.myAllowSave) {
            ++gb.gridy;
            JLabel cannotSaveLabel = new JLabel(SvnBundle.message("svn.cannot.save.credentials.store-auth-creds", new Object[0]));
            cannotSaveLabel.setForeground(UIUtil.getInactiveTextColor());
            panel.add((Component)cannotSaveLabel, gb);
        }
        ++gb.gridy;
        panel.add((Component)new JSeparator(), gb);
        ++gb.gridy;
        gb.weighty = 1.0;
        panel.add((Component)new JLabel(), gb);
        this.myAllowSaveCheckBox.setSelected(false);
        this.myAllowSaveCheckBox.setEnabled(this.myAllowSave);
        this.myKeyButton.addActionListener(this);
        this.myPasswordButton.addActionListener(this);
        this.updateFields();
        this.updateOKButton();
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUserNameText;
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    protected String getDimensionServiceKey() {
        return "svn.sshPasswordDialog";
    }

    public boolean isOKActionEnabled() {
        boolean ok;
        boolean bl = ok = this.myUserNameText != null && this.myUserNameText.getText().trim().length() > 0;
        if (ok) {
            if (this.myPasswordButton.isSelected()) {
                ok = this.myPasswordText != null && this.myPasswordText.getPassword() != null;
            } else if (this.myKeyButton.isSelected()) {
                boolean bl2 = ok = this.myKeyFileText != null && this.myKeyFileText.getText().trim().length() > 0;
            }
            if (ok) {
                String portNumber = this.myPortField.getText();
                try {
                    int port = Integer.parseInt(portNumber);
                    ok = port > 0;
                }
                catch (NumberFormatException nfe) {
                    ok = false;
                }
            }
        }
        return ok;
    }

    public String getUserName() {
        return this.isOK() && this.myUserNameText != null ? this.myUserNameText.getText() : null;
    }

    public String getKeyFile() {
        if (this.myKeyFileText.isEnabled()) {
            return this.myKeyFileText.getText();
        }
        return null;
    }

    public int getPortNumber() {
        String portNumber = this.myPortField.getText();
        int port = 22;
        try {
            port = Integer.parseInt(portNumber);
        }
        catch (NumberFormatException nfe) {
            port = 22;
        }
        if (port <= 0) {
            port = 22;
        }
        return port;
    }

    public String getPassphrase() {
        char[] pwd;
        if (this.myPassphraseText == null || !this.myPassphraseText.isEnabled()) {
            return null;
        }
        if (this.isOK() && (pwd = this.myPassphraseText.getPassword()) != null) {
            return new String(pwd);
        }
        return null;
    }

    public String getPassword() {
        char[] pwd;
        if (this.myPasswordText != null && !this.myPasswordText.isEnabled()) {
            return null;
        }
        if (this.isOK() && this.myPasswordText != null && (pwd = this.myPasswordText.getPassword()) != null) {
            return new String(pwd);
        }
        return null;
    }

    public boolean isSaveAllowed() {
        return this.isOK() && this.myAllowSave && this.myAllowSaveCheckBox != null && this.myAllowSaveCheckBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myPasswordButton || e.getSource() == this.myKeyButton) {
            this.updateFields();
        } else {
            VirtualFile file;
            String path = this.myKeyFileText.getText();
            if (path != null && path.trim().length() > 0) {
                path = "file://" + path.replace(File.separatorChar, '/');
                file = VirtualFileManager.getInstance().findFileByUrl(path);
            } else {
                path = "file://" + System.getProperty(USER_HOME_PROPERTY) + "/.ssh/identity";
                path = path.replace(File.separatorChar, '/');
                file = VirtualFileManager.getInstance().findFileByUrl(path);
            }
            FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
            descriptor.setShowFileSystemRoots(true);
            descriptor.setTitle(SvnBundle.message("dialog.title.openssh.v2.private.key", new Object[0]));
            descriptor.setDescription(SvnBundle.message("dialog.description.openssh.v2.private.key", new Object[0]));
            descriptor.setHideIgnored(false);
            String oldValue = PropertiesComponent.getInstance().getValue("FileChooser.showHiddens");
            PropertiesComponent.getInstance().setValue("FileChooser.showHiddens", Boolean.TRUE.toString());
            VirtualFile[] files = FileChooser.chooseFiles((Project)this.myProject, (FileChooserDescriptor)descriptor, (VirtualFile)file);
            PropertiesComponent.getInstance().setValue("FileChooser.showHiddens", oldValue);
            if (files != null && files.length == 1) {
                path = files[0].getPath().replace('/', File.separatorChar);
                this.myKeyFileText.setText(path);
            }
        }
        this.updateOKButton();
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.isOKActionEnabled());
    }

    private void updateFields() {
        this.myPasswordText.setEnabled(this.myPasswordButton.isSelected());
        this.myPasswordLabel.setEnabled(this.myPasswordButton.isSelected());
        this.myKeyFileText.setEnabled(this.myKeyButton.isSelected());
        this.myKeyFileLabel.setEnabled(this.myKeyButton.isSelected());
        this.myPassphraseLabel.setEnabled(this.myKeyButton.isSelected());
        this.myPassphraseText.setEnabled(this.myKeyButton.isSelected());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOKButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOKButton();
    }
}

