/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.ExcludedFileIndex;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.SvnWorkingCopyFormatHolder;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.checkout.CheckoutEventHandler;
import org.jetbrains.idea.svn.dialogs.CheckoutDialog;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.DefaultSVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNFileFilter;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, CheckoutProvider.Listener listener) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/checkout/SvnCheckoutProvider.doCheckout must not be null");
        }
        CheckoutDialog dialog = new CheckoutDialog(project, listener);
        dialog.show();
    }

    public static void doCheckout(Project project, File target, String url, SVNRevision revision, SVNDepth depth, boolean ignoreExternals, @Nullable CheckoutProvider.Listener listener) {
        String selectedFormat;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((selectedFormat = SvnCheckoutProvider.promptForWCopyFormat(target, project)) == null) {
            return;
        }
        SvnCheckoutProvider.checkout(project, target, url, revision, depth, ignoreExternals, listener, WorkingCopyFormat.getInstance(selectedFormat));
    }

    public static void checkout(final Project project, final File target, final String url, final SVNRevision revision, final SVNDepth depth, final boolean ignoreExternals, final CheckoutProvider.Listener listener, final WorkingCopyFormat selectedFormat) {
        final Ref checkoutSuccessful = new Ref();
        final SVNException[] exception = new SVNException[1];
        Task.Backgroundable checkoutBackgroundTask = new Task.Backgroundable(project, SvnBundle.message("message.title.check.out", new Object[0]), true, VcsConfiguration.getInstance((Project)project).getCheckoutOption()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/checkout/SvnCheckoutProvider$1.run must not be null");
                }
                SvnWorkingCopyFormatHolder.setPresetFormat(selectedFormat);
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                SVNUpdateClient client = SvnVcs.getInstance(project).createUpdateClient();
                client.setEventHandler((ISVNEventHandler)new CheckoutEventHandler(SvnVcs.getInstance(project), false, progressIndicator));
                client.setIgnoreExternals(ignoreExternals);
                try {
                    progressIndicator.setText(SvnBundle.message("progress.text.checking.out", target.getAbsolutePath()));
                    client.doCheckout(SVNURL.parseURIEncoded((String)url), target, SVNRevision.UNDEFINED, revision, depth, true);
                    progressIndicator.checkCanceled();
                    checkoutSuccessful.set((Object)Boolean.TRUE);
                }
                catch (SVNCancelException ignore) {
                }
                catch (SVNException e) {
                    exception[0] = e;
                }
                finally {
                    client.setIgnoreExternals(false);
                    client.setEventHandler(null);
                    SvnWorkingCopyFormatHolder.setPresetFormat(null);
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                VirtualFile vf;
                if (exception[0] != null) {
                    Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.checkout", exception[0].getMessage()), (String)SvnBundle.message("message.title.check.out", new Object[0]));
                }
                if ((vf = RefreshVFsSynchronously.findCreatedFile((File)target)) != null) {
                    vf.refresh(true, true, new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    this.notifyListener();
                                }
                            });
                        }
                    });
                } else {
                    this.notifyListener();
                }
            }

            private void notifyListener() {
                SvnCheckoutProvider.notifyRootManagerIfUnderProject(project, target);
                if (listener != null) {
                    if (!checkoutSuccessful.isNull()) {
                        listener.directoryCheckedOut(target);
                    }
                    listener.checkoutCompleted();
                }
            }
        };
        ProgressManager.getInstance().run((Task)checkoutBackgroundTask);
    }

    private static void notifyRootManagerIfUnderProject(Project project, File directory) {
        VirtualFile[] files;
        if (project.isDefault()) {
            return;
        }
        ProjectLevelVcsManagerEx plVcsManager = ProjectLevelVcsManagerEx.getInstanceChecked((Project)project);
        SvnVcs vcs = (SvnVcs)plVcsManager.findVcsByName("svn");
        for (VirtualFile file : files = vcs.getSvnFileUrlMapping().getNotFilteredRoots()) {
            try {
                if (!FileUtil.isAncestor((File)new File(file.getPath()), (File)directory, (boolean)false)) continue;
                plVcsManager.fireDirectoryMappingsChanged();
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public static boolean promptForWCFormatAndSelect(File target, Project project) {
        String result = SvnCheckoutProvider.promptForWCopyFormat(target, project);
        if (result != null) {
            SvnWorkingCopyFormatHolder.setPresetFormat(WorkingCopyFormat.getInstance(result));
        }
        return result != null;
    }

    @Nullable
    private static String promptForWCopyFormat(File target, Project project) {
        String formatMode = null;
        Ref wasOk = new Ref();
        while (formatMode == null && !Boolean.FALSE.equals(wasOk.get())) {
            formatMode = SvnFormatSelector.showUpgradeDialog(target, project, true, "auto1.6", (Ref<Boolean>)wasOk);
        }
        return Boolean.TRUE.equals(wasOk.get()) ? formatMode : null;
    }

    public static void doExport(final Project project, final File target, final String url, final SVNDepth depth, final boolean ignoreExternals, final boolean force, final String eolStyle) {
        try {
            final SVNException[] exception = new SVNException[1];
            final SVNUpdateClient client = SvnVcs.getInstance(project).createUpdateClient();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    client.setEventHandler((ISVNEventHandler)new CheckoutEventHandler(SvnVcs.getInstance(project), true, progressIndicator));
                    client.setIgnoreExternals(ignoreExternals);
                    try {
                        progressIndicator.setText(SvnBundle.message("progress.text.export", target.getAbsolutePath()));
                        client.doExport(SVNURL.parseURIEncoded((String)url), target, SVNRevision.UNDEFINED, SVNRevision.HEAD, eolStyle, force, depth);
                    }
                    catch (SVNException e) {
                        exception[0] = e;
                    }
                    finally {
                        client.setIgnoreExternals(false);
                        client.setEventHandler(null);
                    }
                }
            }, SvnBundle.message("message.title.export", new Object[0]), true, project);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (SVNException e1) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.export", e1.getMessage()), (String)SvnBundle.message("message.title.export", new Object[0]));
        }
    }

    public static void doImport(final Project project, final File target, final SVNURL url, final SVNDepth depth, final boolean includeIgnored, final String message) {
        final Ref errorMessage = new Ref();
        final SVNCommitClient client = SvnVcs.getInstance(project).createCommitClient();
        final String targetPath = FileUtil.toSystemIndependentName((String)target.getAbsolutePath());
        ExclusiveBackgroundVcsAction.run(project, new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        client.setEventHandler((ISVNEventHandler)new CheckoutEventHandler(SvnVcs.getInstance(project), true, progressIndicator));
                        try {
                            progressIndicator.setText(SvnBundle.message("progress.text.import", target.getAbsolutePath()));
                            VirtualFile targetVf = SvnUtil.getVirtualFile(targetPath);
                            if (targetVf == null) {
                                errorMessage.set((Object)("Can not find file: " + targetPath));
                            } else if (!ExcludedFileIndex.getInstance((Project)project).isInContent(targetVf)) {
                                client.doImport(target, url, message, null, !includeIgnored, false, depth);
                            } else {
                                client.setCommitHandler((ISVNCommitHandler)new MyFilter(LocalFileSystem.getInstance(), new SvnExcludingIgnoredOperation.Filter(project)));
                                client.doImport(target, url, message, null, !includeIgnored, false, depth);
                            }
                        }
                        catch (SVNException e) {
                            errorMessage.set((Object)e.getMessage());
                        }
                        finally {
                            client.setIgnoreExternals(false);
                            client.setEventHandler(null);
                        }
                    }
                }, SvnBundle.message("message.title.import", new Object[0]), true, project);
            }
        });
        if (!errorMessage.isNull()) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.import", errorMessage.get()), (String)SvnBundle.message("message.title.import", new Object[0]));
        }
    }

    public String getVcsName() {
        return "_Subversion";
    }

    private static class MyFilter
    extends DefaultSVNCommitHandler
    implements ISVNFileFilter {
        private final LocalFileSystem myLfs;
        private final SvnExcludingIgnoredOperation.Filter myFilter;

        private MyFilter(LocalFileSystem lfs, SvnExcludingIgnoredOperation.Filter filter) {
            this.myLfs = lfs;
            this.myFilter = filter;
        }

        public boolean accept(File file) throws SVNException {
            VirtualFile vf = this.myLfs.findFileByIoFile(file);
            return vf != null && this.myFilter.accept(vf);
        }
    }
}

