/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.idea.svn.SvnAuthenticationManager;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.integrate.SvnBranchItem;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class BranchesLoader {
    private static Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.branchConfig.BranchesLoader");

    private BranchesLoader() {
    }

    public static List<SvnBranchItem> loadBranches(Project project, String url) throws SVNException {
        final LinkedList<SvnBranchItem> result = new LinkedList<SvnBranchItem>();
        SvnConfiguration configuration = SvnConfiguration.getInstance(project);
        SvnAuthenticationManager passiveManager = configuration.getPassiveAuthenticationManager();
        SVNLogClient logClient = new SVNLogClient((ISVNAuthenticationManager)passiveManager, configuration.getOptions(project));
        final SVNURL branchesUrl = SVNURL.parseURIEncoded((String)url);
        logClient.doList(branchesUrl, SVNRevision.UNDEFINED, SVNRevision.HEAD, false, false, new ISVNDirEntryHandler(){

            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                SVNURL currentUrl = dirEntry.getURL();
                if (!branchesUrl.equals((Object)currentUrl)) {
                    String url = currentUrl.toString();
                    if (dirEntry.getDate() != null) {
                        result.add(new SvnBranchItem(url, dirEntry.getDate(), dirEntry.getRevision()));
                    }
                }
            }
        });
        Collections.sort(result);
        return result;
    }
}

